/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.propertytable;

import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.jboss.tools.common.ui.BrowserUtil;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.propertytable.AbstractPropertyCellLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.propertytable.IProperty;
import org.jboss.tools.openshift.express.internal.ui.utils.TreeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class PropertyValueCellLabelProvider
extends AbstractPropertyCellLabelProvider {
    @Override
    protected void update(IProperty property, ViewerCell cell) {
        if (property.isLink()) {
            this.createStyledText(property, cell);
            this.createLink(property, cell);
        } else {
            cell.setText(property.getValue());
        }
    }

    protected void createLink(IProperty property, ViewerCell cell) {
        if (StringUtils.isEmpty((String)property.getValue())) {
            return;
        }
        Hyperlink link = new Hyperlink((Composite)((Tree)cell.getControl()), 0);
        link.setBackground(cell.getBackground());
        link.setForeground(JFaceResources.getColorRegistry().get("ACTIVE_HYPERLINK_COLOR"));
        link.setFont(cell.getFont());
        link.setUnderlined(true);
        link.setText(property.getValue());
        link.setBackground(cell.getBackground());
        link.addMouseListener((MouseListener)this.onLinkClicked(property.getValue()));
        UIUtils.copyMenuOf(cell.getControl(), (Control)link);
        TreeUtils.createTreeEditor((Control)link, property.getValue(), cell);
    }

    private void createStyledText(IProperty property, final ViewerCell cell) {
        StyledString.Styler style = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = cell.getControl().getDisplay().getSystemColor(9);
                textStyle.underline = true;
            }
        };
        StyledString styledString = new StyledString(StringUtils.null2emptyString((String)property.getValue()), style);
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setText(styledString.getString());
    }

    protected MouseAdapter onLinkClicked(final String url) {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    BrowserUtil.checkedCreateExternalBrowser((String)url, (String)"org.jboss.tools.openshift.express.ui", (ILog)OpenShiftUIActivator.getDefault().getLog());
                }
            }
        };
    }
}

