/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.property;

import com.openshift.client.OpenShiftException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionURL;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class ConnectionPropertySource
implements IPropertySource {
    private static final String PROPERTY_DOMAINS = "Domains";
    private static final String PROPERTY_USERNAME = "Username";
    private static final String PROPERTY_KEY = "Persisted Key";
    private final Connection connection;

    public ConnectionPropertySource(Connection connection) {
        this.connection = connection;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new PropertyDescriptor((Object)PROPERTY_KEY, PROPERTY_KEY), new PropertyDescriptor((Object)PROPERTY_USERNAME, PROPERTY_USERNAME), new PropertyDescriptor((Object)PROPERTY_DOMAINS, PROPERTY_DOMAINS)};
    }

    public Object getPropertyValue(Object id) {
        try {
            boolean requiresConnect;
            if (!this.connection.isConnected() && !this.connection.canPromptForPassword()) {
                return OpenShiftExpressUIMessages.USER_NOT_CONNECTED_LABEL;
            }
            boolean bl = requiresConnect = !this.connection.isConnected() && this.connection.canPromptForPassword();
            if (requiresConnect || !this.connection.isLoaded()) {
                this.loadRemoteDetails(this.connection);
            }
            if (PROPERTY_USERNAME.equals(id)) {
                return this.getUsername(this.connection);
            }
            if (PROPERTY_DOMAINS.equals(id) && this.connection.hasDomain()) {
                return this.getDomains(this.connection);
            }
            if (PROPERTY_KEY.equals(id)) {
                return this.getKey(this.connection);
            }
        }
        catch (OpenShiftException e) {
            Logger.error("Could not get selected object's property '" + id + "'.", e);
        }
        return null;
    }

    private Object getUsername(Connection connection) {
        return connection.getUsername();
    }

    private Object getDomains(Connection connection) {
        return OpenShiftResourceLabelUtils.toString((List)connection.getDomains());
    }

    private String getKey(Connection connection) {
        try {
            return ConnectionURL.forConnection((Connection)connection).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (MalformedURLException malformedURLException) {}
        return "";
    }

    private void loadRemoteDetails(final Connection connection) throws OpenShiftException {
        IRunnableWithProgress longRunning = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                monitor.beginTask("Loading Connection Details", 200);
                try {
                    if (!connection.isConnected() && connection.canPromptForPassword()) {
                        connection.connect();
                    }
                    monitor.worked(100);
                    if (connection.isConnected()) {
                        connection.load();
                    }
                    monitor.worked(100);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(longRunning);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof OpenShiftException) {
                throw (OpenShiftException)cause;
            }
            new OpenShiftException(cause, "Could not load details for user {0} on {1}", new Object[]{connection.getUsername(), connection.getHost()});
        }
        catch (InterruptedException interruptedException) {}
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertySet(Object id) {
        return PROPERTY_USERNAME.equals(id) || PROPERTY_DOMAINS.equals(id) || PROPERTY_KEY.equals(id);
    }
}

