/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftTimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class RestartApplicationJob
extends AbstractDelegatingMonitorJob {
    private IApplication application;
    private LoadApplicationJob applicationJob;

    public RestartApplicationJob(IApplication application) {
        super(NLS.bind((String)OpenShiftExpressUIMessages.RESTARTING_APPLICATION, (Object)application.getName()));
        this.application = application;
    }

    public RestartApplicationJob(LoadApplicationJob applicationJob) {
        super(NLS.bind((String)OpenShiftExpressUIMessages.RESTARTING_APPLICATION, (Object)""));
        this.applicationJob = applicationJob;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        Logger.debug(OpenShiftExpressUIMessages.RESTARTING_APPLICATION);
        try {
            IApplication application = this.getApplication();
            if (application != null) {
                this.getApplication().restart();
            }
        }
        catch (OpenShiftTimeoutException openShiftTimeoutException) {
        }
        catch (OpenShiftException e) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not restart application \"{0}\"", (Object)this.application.getName()), e);
        }
        return Status.OK_STATUS;
    }

    private IApplication getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return this.applicationJob.getApplication();
    }
}

