/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;

public class DestroyDomainJob
extends AbstractDelegatingMonitorJob {
    private IDomain domain;
    private boolean force;

    public DestroyDomainJob(IDomain domain, boolean force) {
        super(NLS.bind((String)OpenShiftExpressUIMessages.DESTROYING_DOMAIN, (Object)domain.getId()));
        this.domain = domain;
        this.force = force;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            this.domain.destroy(this.force);
            ConnectionsModelSingleton.getInstance().fireConnectionChanged(this.domain.getUser());
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OpenShiftException e) {
            Status status = new Status(4, "org.jboss.tools.openshift.express.ui", NLS.bind((String)"Failed to destroy domain \"{0}\"", (Object)this.domain.getId()), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

