/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftSSHOperationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHSessionRepository;

public class CreateSSHSessionJob
extends Job {
    private IApplication application;
    private boolean validSession = false;
    private LoadApplicationJob applicationJob;

    public CreateSSHSessionJob(IApplication application) {
        super("Verifying SSH session...");
        this.application = application;
    }

    public CreateSSHSessionJob(LoadApplicationJob job) {
        super("Verifying SSH session...");
        this.applicationJob = job;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IApplication application = this.getApplication();
        if (application == null) {
            return OpenShiftUIActivator.createErrorStatus("Could not verify SSH seesion. Application was not found.");
        }
        try {
            boolean hasAlreadySSHSession = application.hasSSHSession();
            if (!hasAlreadySSHSession) {
                Logger.debug(NLS.bind((String)"Opening a new SSH Session for application {0}.", (Object)application.getName()));
                Session session = SSHSessionRepository.getInstance().getSession(application);
                application.setSSHSession(session);
            }
            this.validSession = application.hasSSHSession();
            return Status.OK_STATUS;
        }
        catch (OpenShiftSSHOperationException openShiftSSHOperationException) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not verify SSH session for application {0}", (Object)application));
        }
    }

    private IApplication getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return this.applicationJob.getApplication();
    }

    public final boolean isValidSession() {
        return this.validSession;
    }
}

