/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.console;

import com.openshift.client.IApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.tools.openshift.express.core.IConsoleUtility;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class ConsoleUtils
implements IConsoleUtility {
    public static final String CONSOLE_TYPE_KEY = "ConsoleType";
    public static final String CONSOLE_TYPE_VALUE = "OpenShiftTailConsole";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String NL = "\n";

    public static void registerConsoleListener(IConsoleListener consoleListener) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        consoleManager.addConsoleListener(consoleListener);
    }

    public static MessageConsole findMessageConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole console = new MessageConsole(name, null);
        console.setAttribute(CONSOLE_TYPE_KEY, (Object)CONSOLE_TYPE_VALUE);
        consoleManager.addConsoles(new IConsole[]{console});
        return console;
    }

    public static void displayConsoleView(IServer server) {
        if (server == null) {
            return;
        }
        MessageConsole console = ConsoleUtils.findMessageConsole(server.getId());
        if (console == null) {
            return;
        }
        ConsoleUtils.displayConsoleView((IConsole)console);
    }

    public static MessageConsole displayConsoleView(IApplication application) {
        if (application == null) {
            return null;
        }
        MessageConsole console = ConsoleUtils.findMessageConsole(ConsoleUtils.getMessageConsoleName(application));
        if (console == null) {
            return null;
        }
        console.clearConsole();
        ConsoleUtils.displayConsoleView((IConsole)console);
        return console;
    }

    private static String getMessageConsoleName(IApplication application) {
        return MessageFormat.format("Snapshot Restore/Deploy for application {0} ({1}):", application.getName(), application.getDomain().getId());
    }

    public static void displayConsoleView(final IConsole console) {
        UIUtils.ensureDisplayExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart part = null;
                try {
                    part = UIUtil.bringViewToFront((String)"org.eclipse.ui.console.ConsoleView");
                    if (part == null) {
                        Logger.warn("Could not open console, org.eclipse.ui.console.ConsoleView was not found");
                        return;
                    }
                    IConsoleView view = (IConsoleView)part.getAdapter(IConsoleView.class);
                    if (view == null) {
                        return;
                    }
                    view.display(console);
                }
                catch (PartInitException e) {
                    Logger.warn("Could not open console view", e);
                }
            }
        });
    }

    public static OutputStream getConsoleOutputStream(IServer server) {
        MessageConsole console = ConsoleUtils.findMessageConsole(server.getId());
        if (console == null) {
            return null;
        }
        return console.newMessageStream();
    }

    public static void appendGitPushToConsole(IServer server, PushOperationResult result) {
        ConsoleUtils.appendToConsole(server, ConsoleUtils.getPushResultAsString(result));
    }

    private static String getPushResultAsString(PushOperationResult pushOperationResult) {
        StringBuilder result = new StringBuilder(EMPTY_STRING);
        result.append(ConsoleUtils.getPushErrors(pushOperationResult));
        result.append(NL);
        Set uris = pushOperationResult.getURIs();
        for (URIish uri : uris) {
            if (pushOperationResult.getPushResult(uri) == null) continue;
            for (RemoteRefUpdate update : pushOperationResult.getPushResult(uri).getRemoteUpdates()) {
                result.append(ConsoleUtils.getOneResultAsString(pushOperationResult, uri, update));
            }
        }
        return result.toString();
    }

    private static String getOneResultAsString(PushOperationResult pushOperationResult, URIish uri, RemoteRefUpdate update) {
        StringBuilder result = new StringBuilder(EMPTY_STRING);
        result.append("Repository");
        result.append(SPACE);
        result.append(uri.toString());
        result.append(Text.DELIMITER);
        result.append(Text.DELIMITER);
        String message = update.getMessage();
        if (message != null) {
            result.append(message).append(Text.DELIMITER);
        }
        StringBuilder messagesBuffer = new StringBuilder(pushOperationResult.getPushResult(uri).getMessages());
        ConsoleUtils.trim(messagesBuffer);
        if (messagesBuffer.length() > 0) {
            result.append((CharSequence)messagesBuffer).append(Text.DELIMITER);
        }
        ConsoleUtils.trim(result);
        return result.toString();
    }

    private static void trim(StringBuilder s) {
        while (s.length() > 0 && (s.charAt(0) == '\n' || s.charAt(0) == '\r')) {
            s.deleteCharAt(0);
        }
        while (s.length() > 0 && (s.charAt(s.length() - 1) == '\n' || s.charAt(s.length() - 1) == '\r')) {
            s.deleteCharAt(s.length() - 1);
        }
    }

    private static String getPushErrors(PushOperationResult result) {
        StringBuilder messages = new StringBuilder();
        for (URIish uri : result.getURIs()) {
            String errorMessage = result.getErrorMessage(uri);
            if (errorMessage == null || errorMessage.length() <= 0) continue;
            if (messages.length() > 0) {
                messages.append(System.getProperty("line.separator"));
            }
            messages.append(errorMessage);
        }
        return messages.toString();
    }

    public static void appendToConsole(IServer server, String message) {
        if (OpenShiftServerUtils.isOpenShiftRuntime((IServerAttributes)server)) {
            MessageConsole console = ConsoleUtils.findMessageConsole(server.getId());
            MessageConsoleStream newMessageStream = console.newMessageStream();
            newMessageStream.print(message);
            try {
                newMessageStream.close();
            }
            catch (IOException iOException) {}
            ConsoleUtils.displayConsoleView((IConsole)console);
        }
    }

    public void displayServerConsoleView(IServer server) {
        ConsoleUtils.displayConsoleView(server);
    }

    public OutputStream getServerConsoleOutputStream(IServer server) {
        return ConsoleUtils.getConsoleOutputStream(server);
    }

    public void appendToServerConsole(IServer server, String msg) {
        ConsoleUtils.appendToConsole(server, msg);
    }
}

