/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.WizardUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.SaveSnapshotWizard;

public class SaveSnapshotHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        IApplication application = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IApplication.class);
        if (application == null) {
            IServer server = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IServer.class);
            if (server == null) {
                return OpenShiftUIActivator.createErrorStatus("Could not find application to snapshot");
            }
            final LoadApplicationJob loadApplicationJob = new LoadApplicationJob(server);
            new JobChainBuilder((Job)loadApplicationJob).runWhenSuccessfullyDone((Job)new UIJob("Opening Save Snapshot wizard..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IApplication application = loadApplicationJob.getApplication();
                    if (application == null) {
                        return OpenShiftUIActivator.createCancelStatus("Could not find application to save the snapshot for.");
                    }
                    SaveSnapshotHandler.this.openSaveSnapshotWizard(loadApplicationJob.getApplication(), HandlerUtil.getActiveShell((ExecutionEvent)event));
                    return Status.OK_STATUS;
                }
            }).schedule();
            return Status.OK_STATUS;
        }
        this.openSaveSnapshotWizard(application, HandlerUtil.getActiveShell((ExecutionEvent)event));
        return Status.OK_STATUS;
    }

    private void openSaveSnapshotWizard(IApplication application, Shell shell) {
        WizardUtils.openWizard((IWizard)new SaveSnapshotWizard(application), shell);
    }
}

