/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.internal.client.utils.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.job.RestartApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class RestartApplicationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IApplication application = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IApplication.class);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (application != null) {
            return this.restartFor(application, shell);
        }
        IServer server = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IServer.class);
        if (server == null) {
            return OpenShiftUIActivator.createCancelStatus("Could not restart application: server not found.");
        }
        return this.restartFor(server, shell);
    }

    private Object restartFor(IApplication application, Shell shell) {
        if (!this.promptUserToConfirm(application.getName(), shell)) {
            return OpenShiftUIActivator.createCancelStatus("Restarting application {0} was cancelled.", application.getName());
        }
        new RestartApplicationJob(application).schedule();
        return Status.OK_STATUS;
    }

    private IStatus restartFor(IServer server, Shell shell) {
        String applicationName = OpenShiftServerUtils.getApplicationName((IServerAttributes)server);
        if (StringUtils.isEmpty((String)applicationName)) {
            return OpenShiftUIActivator.createCancelStatus(NLS.bind((String)"Could not restart application: application for server {0} not found.", (Object)server.getName()));
        }
        if (!this.promptUserToConfirm(applicationName, shell)) {
            return OpenShiftUIActivator.createCancelStatus("Restarting application {0} was cancelled.", applicationName);
        }
        LoadApplicationJob applicationJob = new LoadApplicationJob(server);
        new JobChainBuilder((Job)applicationJob).runWhenSuccessfullyDone((Job)new RestartApplicationJob(applicationJob)).schedule();
        return Status.OK_STATUS;
    }

    private boolean promptUserToConfirm(String applicationName, Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)"Restart Application", (String)NLS.bind((String)"You are about to restart application {0}.\n\nRestarting an application in production may be harmful. Are you sure that you want to restart your application?", (Object)applicationName));
    }
}

