/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftResource;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.job.FireConnectionsChangedJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class RefreshResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object resource = this.getResource(selection);
        if (resource != null) {
            this.refresh(resource);
        }
        return null;
    }

    private Object getResource(ISelection selection) {
        IOpenShiftResource resource = UIUtils.getFirstElement(selection, IOpenShiftResource.class);
        if (resource == null) {
            resource = UIUtils.getFirstElement(selection, Connection.class);
        }
        return resource;
    }

    private void refresh(final Object element) {
        AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Loading OpenShift information..."){

            @Override
            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("Loading OpenShift informations...", -1);
                        if (element instanceof Connection) {
                            ((Connection)element).refresh();
                        } else if (element instanceof IOpenShiftResource) {
                            ((IOpenShiftResource)element).refresh();
                        }
                    }
                    catch (OpenShiftException e) {
                        Logger.error("Failed to refresh element", e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        Connection connection = this.getConnection(element);
        if (connection != null) {
            new JobChainBuilder((Job)job).runWhenSuccessfullyDone((Job)new FireConnectionsChangedJob(connection)).schedule();
        } else {
            job.schedule();
        }
    }

    private Connection getConnection(Object resource) {
        Connection connection = null;
        if (resource instanceof Connection) {
            connection = (Connection)resource;
        } else if (resource instanceof IDomain) {
            IDomain domain = (IDomain)resource;
            connection = ConnectionsModelSingleton.getInstance().getConnectionByResource(domain.getUser());
        } else if (resource instanceof IApplication) {
            IApplication application = (IApplication)resource;
            connection = ConnectionsModelSingleton.getInstance().getConnectionByResource(application);
        }
        return connection;
    }
}

