/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.job.CreateSSHSessionJob;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.portforward.PortForwardingWizard;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.OkButtonWizardDialog;

public class PortForwardingHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IApplication application = UIUtils.getFirstElement(selection, IApplication.class);
        if (application != null) {
            this.openPortForwardingDialogFor(application);
        } else {
            IServer server = UIUtils.getFirstElement(selection, IServer.class);
            if (server != null) {
                this.openPortForwardingDialogFor(server);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus openPortForwardingDialogFor(final IApplication application) {
        final CreateSSHSessionJob sshJob = new CreateSSHSessionJob(application);
        new JobChainBuilder((Job)sshJob).runWhenSuccessfullyDone((Job)new UIJob("Opening port forwarding dialog"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (sshJob.isValidSession()) {
                    PortForwardingHandler.this.openPortForwardingWizard(application);
                }
                return Status.OK_STATUS;
            }
        }).schedule();
        return Status.OK_STATUS;
    }

    private void openPortForwardingDialogFor(IServer server) {
        final LoadApplicationJob applicationJob = new LoadApplicationJob(server);
        final CreateSSHSessionJob sshJob = new CreateSSHSessionJob(applicationJob);
        new JobChainBuilder((Job)applicationJob).runWhenSuccessfullyDone((Job)sshJob).runWhenSuccessfullyDone((Job)new UIJob("Opening port forwarding dialog"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IApplication application = applicationJob.getApplication();
                if (application != null && sshJob.isValidSession()) {
                    PortForwardingHandler.this.openPortForwardingWizard(application);
                }
                return Status.OK_STATUS;
            }
        }).schedule();
    }

    private void openPortForwardingWizard(IApplication application) {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        OkButtonWizardDialog dialog = new OkButtonWizardDialog(shell, (IWizard)new PortForwardingWizard(application));
        dialog.setMinimumPageSize(700, 400);
        dialog.create();
        dialog.open();
    }
}

