/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.ModifyModulesWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewServerWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.server.BehaviorTaskModelUtil;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.WizardUtils;

public class NewServerAdapterHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IApplication application = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IApplication.class);
        if (application == null) {
            return OpenShiftUIActivator.createCancelStatus("Cannot create server adapter: no application selected.");
        }
        try {
            NewServerWizard wizard = new NewServerWizard("org.jboss.tools.openshift.express.openshift.server.type");
            BehaviorTaskModelUtil.put(application, wizard.getTaskModel());
            IDomain domain = application.getDomain();
            BehaviorTaskModelUtil.put(domain, wizard.getTaskModel());
            Connection connection = ConnectionsModelSingleton.getInstance().getConnectionByResource(application);
            if (connection == null) {
                return OpenShiftUIActivator.createCancelStatus(NLS.bind((String)"Cannot create server adapter: connection for application {0} not found.", (Object)application.getName()));
            }
            BehaviorTaskModelUtil.put(connection, wizard.getTaskModel());
            WizardUtils.openWizard(400, 700, (IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            return Status.OK_STATUS;
        }
        catch (OpenShiftException e) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not create OpenShift server for application {0}", (Object)application.getName()), e);
        }
    }

    public class NewServerWizard
    extends TaskWizard
    implements INewWizard {
        public NewServerWizard(final String serverType) {
            super(Messages.wizNewServerWizardTitle, new WizardFragment(){

                protected void createChildFragments(List<WizardFragment> list) {
                    list.add((WizardFragment)new NewServerWizardFragment(null, serverType));
                    list.add(WizardTaskUtil.TempSaveRuntimeFragment);
                    list.add(WizardTaskUtil.TempSaveServerFragment);
                    list.add((WizardFragment)new ModifyModulesWizardFragment());
                    list.add((WizardFragment)new TasksWizardFragment());
                    list.add(WizardTaskUtil.SaveRuntimeFragment);
                    list.add(WizardTaskUtil.SaveServerFragment);
                    list.add(WizardTaskUtil.SaveHostnameFragment);
                }
            });
        }

        public void init(IWorkbench newWorkbench, IStructuredSelection newSelection) {
        }
    }
}

