/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.express.internal.ui.job.CreateSSHSessionJob;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHSessionRepository;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class ListAllEnvironmentVariablesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IApplication application = UIUtils.getFirstElement(selection, IApplication.class);
        if (application != null) {
            this.showEnvironmentPropertiesFor(application);
        } else {
            IServer server = UIUtils.getFirstElement(selection, IServer.class);
            if (server == null) {
                return Status.CANCEL_STATUS;
            }
            this.showEnvironmentPropertiesFor(server);
        }
        return Status.OK_STATUS;
    }

    private void showEnvironmentPropertiesFor(IServer server) {
        final LoadApplicationJob job = new LoadApplicationJob(server);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    IApplication application = job.getApplication();
                    ListAllEnvironmentVariablesHandler.this.showEnvironmentPropertiesFor(application);
                }
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private void showEnvironmentPropertiesFor(final IApplication application) {
        final CreateSSHSessionJob job = new CreateSSHSessionJob(application);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && job.isValidSession()) {
                    ListAllEnvironmentVariablesHandler.this.showEnvironmentProperties(application);
                }
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private void showEnvironmentProperties(final IApplication application) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!application.hasSSHSession()) {
                        application.setSSHSession(SSHSessionRepository.getInstance().getSession(application));
                    }
                    List props = application.getEnvironmentProperties();
                    MessageConsole console = ConsoleUtils.displayConsoleView(application);
                    MessageConsoleStream stream = console.newMessageStream();
                    for (String prop : props) {
                        stream.println(prop);
                    }
                    ConsoleUtils.displayConsoleView((IConsole)console);
                }
                catch (Exception e) {
                    OpenShiftUIActivator.createErrorStatus("Failed to display remote environment variables", e);
                }
            }
        });
    }
}

