/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.command.AbstractDomainHandler;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EditEmbeddedCartridgesWizard;

public class EditCartridgesHandler
extends AbstractDomainHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        IApplication application = this.getApplication(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (application != null) {
            return this.openEditEmbeddedCartridgesWizard(application, HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        IServer server = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IServer.class);
        if (server == null) {
            return OpenShiftUIActivator.createErrorStatus("Could not find application to restart");
        }
        final LoadApplicationJob job = new LoadApplicationJob(server);
        new JobChainBuilder((Job)job).runWhenSuccessfullyDone((Job)new UIJob("Opening Edit Embedded Cartridges wizard..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IApplication application = job.getApplication();
                if (application == null) {
                    return OpenShiftUIActivator.createCancelStatus("Could not find application to edit the embedded cartridges of");
                }
                return EditCartridgesHandler.this.openEditEmbeddedCartridgesWizard(application, HandlerUtil.getActiveShell((ExecutionEvent)event));
            }
        }).schedule();
        return Status.OK_STATUS;
    }

    protected IApplication getApplication(ISelection selection) {
        IEmbeddedCartridge cartridge;
        IApplication application = UIUtils.getFirstElement(selection, IApplication.class);
        if (application == null && (cartridge = UIUtils.getFirstElement(selection, IEmbeddedCartridge.class)) != null) {
            application = cartridge.getApplication();
        }
        return application;
    }

    protected IStatus openEditEmbeddedCartridgesWizard(IApplication application, Shell shell) {
        try {
            WizardUtils.openWizardDialog((IWizard)new EditEmbeddedCartridgesWizard(application, ConnectionsModelSingleton.getInstance().getConnectionByResource(application)), (Shell)shell);
            return Status.OK_STATUS;
        }
        catch (OpenShiftException e) {
            Logger.error("Failed to edit cartridges", e);
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Failed to edit cartridges for application {0}", (Object)application.getName()), e);
        }
    }
}

