/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.IUser;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.job.DeleteApplicationsJob;
import org.jboss.tools.openshift.express.internal.ui.job.FireConnectionsChangedJob;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class DeleteApplicationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        List<IApplication> appsToDelete = this.getApplicationsToDelete(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (appsToDelete != null && !appsToDelete.isEmpty()) {
            return this.deleteApplications(appsToDelete, shell);
        }
        IServer server = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IServer.class);
        if (server == null) {
            return OpenShiftUIActivator.createCancelStatus("Could not find the server to delete");
        }
        return this.deleteApplicationAndServer(server, shell);
    }

    private IStatus deleteApplications(List<IApplication> appsToDelete, Shell shell) {
        if (this.promptForDeleteConfirmation(appsToDelete, shell)) {
            List<IUser> users = this.getUsers(appsToDelete);
            new JobChainBuilder((Job)new DeleteApplicationsJob(appsToDelete)).runWhenDone((Job)new FireConnectionsChangedJob(users)).schedule();
            return Status.OK_STATUS;
        }
        return OpenShiftUIActivator.createCancelStatus("Cancelled application removal.");
    }

    private List<IUser> getUsers(List<IApplication> applications) {
        ArrayList<IUser> users = new ArrayList<IUser>();
        if (applications == null || applications.size() == 0) {
            return users;
        }
        for (IApplication application : applications) {
            users.add(application.getDomain().getUser());
        }
        return users;
    }

    private boolean promptForDeleteConfirmation(List<IApplication> appsToDelete, Shell shell) {
        if (appsToDelete.size() == 1) {
            return MessageDialog.openConfirm((Shell)shell, (String)"Application removal", (String)NLS.bind((String)"You are about to destroy the \"{0}\" application.\nThis is NOT reversible, all remote data for this application will be removed.", (Object)appsToDelete.get(0).getName()));
        }
        if (appsToDelete.size() > 1) {
            return MessageDialog.openConfirm((Shell)shell, (String)"Application removal", (String)NLS.bind((String)"You are about to destroy {0} applications.\nThis is NOT reversible, all remote data for those applications will be removed.", (Object)appsToDelete.size()));
        }
        return false;
    }

    private IStatus deleteApplicationAndServer(final IServer server, Shell shell) {
        if (MessageDialog.openConfirm((Shell)shell, (String)"Application and Server removal", (String)NLS.bind((String)"You are about to remove the application and the server \"{0}\".\nThis is NOT reversible, all remote data for this application and the local server adapter will be removed.", (Object)server.getName()))) {
            LoadApplicationJob applicationJob = new LoadApplicationJob(server);
            new JobChainBuilder((Job)applicationJob).runWhenSuccessfullyDone((Job)new DeleteApplicationsJob(applicationJob)).runWhenSuccessfullyDone((Job)new FireConnectionsChangedJob(applicationJob)).runWhenSuccessfullyDone((Job)new AbstractDelegatingMonitorJob(NLS.bind((String)"Delete Server Adapter {0}", (Object)server.getName())){

                @Override
                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        server.delete();
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }).schedule();
        }
        return Status.OK_STATUS;
    }

    private List<IApplication> getApplicationsToDelete(ISelection selection) {
        ArrayList<IApplication> appsToDelete = new ArrayList<IApplication>();
        if (!(selection instanceof IStructuredSelection)) {
            return appsToDelete;
        }
        for (Object element : (IStructuredSelection)selection) {
            if (!(element instanceof IApplication)) continue;
            appsToDelete.add((IApplication)element);
        }
        return appsToDelete;
    }
}

