/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.portlet.configurators;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.maven.core.internal.project.facet.MavenFacetInstallDataModelProvider;
import org.jboss.tools.maven.portlet.MavenPortletActivator;
import org.jboss.tools.maven.portlet.Messages;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.portlet.core.internal.project.facet.JSFPortletFacetInstallDataModelProvider;
import org.jboss.tools.portlet.core.internal.project.facet.PortletFacetInstallDataModelProvider;

public class PortletProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String PORTLET_API_GROUP_ID = "javax.portlet";
    private static final String PORTLET_API_ARTIFACT_ID = "portlet-api";
    private static final String PORTLETBRIDGE_API_GROUP_ID = "org.jboss.portletbridge";
    private static final String PORTLETBRIDGE_API_ARTIFACT_ID = "portletbridge-api";
    public static final String PORTLET_CONFIGURATION_ERROR_MARKER_ID = "org.jboss.tools.maven.portlet.problem.configuration";
    protected static final IProjectFacet dynamicWebFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    protected static final IProjectFacetVersion dynamicWebVersion = dynamicWebFacet.getVersion("2.5");
    protected static final IProjectFacet jsfFacet;
    protected static final IProjectFacet portletFacet;
    protected static final IProjectFacetVersion portletVersion10;
    protected static final IProjectFacetVersion portletVersion20;
    protected static final IProjectFacet m2Facet;
    protected static final IProjectFacetVersion m2Version;
    protected static final IProjectFacetVersion jsfportletFacetVersion;

    static {
        portletFacet = ProjectFacetsManager.getProjectFacet((String)"jboss.portlet");
        portletVersion20 = portletFacet.getVersion("2.0");
        portletVersion10 = portletFacet.getVersion("1.0");
        m2Facet = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
        m2Version = m2Facet.getVersion("1.0");
        jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        jsfportletFacetVersion = ProjectFacetsManager.getProjectFacet((String)"jboss.jsfportlet").getVersion("1.0");
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    /*
     * Unable to fully structure code
     */
    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        block6: {
            packaging = mavenProject.getPackaging();
            if (!"war".equals(packaging)) {
                return;
            }
            store = Activator.getDefault().getPreferenceStore();
            configurePortlet = store.getBoolean("configurePortlet");
            if (!configurePortlet) {
                return;
            }
            portletVersion = Activator.getDefault().getDependencyVersion(mavenProject, "javax.portlet", "portlet-api");
            jsfportletVersion = Activator.getDefault().getDependencyVersion(mavenProject, "org.jboss.portletbridge", "portletbridge-api");
            if (portletVersion != null && (fproj = ProjectFacetsManager.create((IProject)project)) != null) {
                this.markerManager.deleteMarkers((IResource)project, "org.jboss.tools.maven.portlet.problem.configuration");
                try {
                    this.installWarFacets(fproj, portletVersion, jsfportletVersion, monitor);
                    break block6;
                }
                catch (CoreException e) {
                    status = e.getStatus();
                    errorMessage = status == null || status.getMessage() == null ? e.getMessage() : status.getMessage();
                    markerMessage = NLS.bind((String)Messages.PortletProjectConfigurator_Error_installing_facet, (Object[])new Object[]{PortletProjectConfigurator.portletFacet.getLabel(), portletVersion, errorMessage});
                    this.addErrorMarker(fproj.getProject(), markerMessage);
                    var17_14 = status.getChildren();
                    var16_15 = var17_14.length;
                    var15_16 = 0;
                    ** while (var15_16 < var16_15)
                }
lbl-1000:
                // 1 sources

                {
                    st = var17_14[var15_16];
                    this.addErrorMarker(fproj.getProject(), st.getMessage());
                    ++var15_16;
                    continue;
                }
            }
        }
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IProject project;
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null && this.isWTPProject(project = facade.getProject())) {
            MavenProject mavenProject = facade.getMavenProject(monitor);
            this.configureInternal(mavenProject, project, monitor);
        }
        super.mavenProjectChanged(event, monitor);
    }

    private boolean isWTPProject(IProject project) {
        return ModuleCoreNature.getModuleCoreNature((IProject)project) != null;
    }

    private void installM2Facet(IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(m2Facet)) {
            IDataModel config = (IDataModel)new MavenFacetInstallDataModelProvider().create();
            config.setBooleanProperty("mavenProjectExists", true);
            fproj.installProjectFacet(m2Version, (Object)config, monitor);
        }
    }

    private void installWarFacets(IFacetedProject fproj, String portletVersion, String jsfportletVersion, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(dynamicWebFacet)) {
            MavenPortletActivator.log(NLS.bind((String)Messages.PortletProjectConfigurator_The_project_does_not_contain_the_Web_Module_facet, (Object)fproj.getProject().getName()));
            return;
        }
        this.installM2Facet(fproj, monitor);
        this.installPortletFacet(fproj, portletVersion, jsfportletVersion, monitor);
    }

    private void installPortletFacet(IFacetedProject fproj, String portletVersionString, String jsfportletVersion, IProgressMonitor monitor) throws CoreException {
        IDataModel model;
        if (!fproj.hasProjectFacet(portletFacet)) {
            if (portletVersionString.startsWith("1.0")) {
                model = this.createPortletDataModel(fproj, portletVersion10);
                fproj.installProjectFacet(portletVersion10, (Object)model, monitor);
            }
            if (portletVersionString.startsWith("2.0")) {
                model = this.createPortletDataModel(fproj, portletVersion20);
                fproj.installProjectFacet(portletVersion20, (Object)model, monitor);
            }
        }
        if (fproj.hasProjectFacet(portletFacet) && fproj.hasProjectFacet(jsfFacet) && jsfportletVersion != null && !fproj.hasProjectFacet(jsfportletFacetVersion)) {
            model = this.createJSFPortletDataModel(fproj, jsfportletFacetVersion);
            fproj.installProjectFacet(jsfportletFacetVersion, (Object)model, monitor);
        }
    }

    private IDataModel createPortletDataModel(IFacetedProject fproj, IProjectFacetVersion facetVersion) {
        IDataModel config = (IDataModel)new PortletFacetInstallDataModelProvider().create();
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"portlet-no-op-library-provider");
        libraryDelegate.setLibraryProvider(provider);
        config.setProperty("PORTLET_LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
        return config;
    }

    private IDataModel createJSFPortletDataModel(IFacetedProject fproj, IProjectFacetVersion facetVersion) {
        IDataModel config = (IDataModel)new JSFPortletFacetInstallDataModelProvider().create();
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"jsfportlet-no-op-library-provider");
        libraryDelegate.setLibraryProvider(provider);
        config.setProperty("JSFPORTLET_LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
        return config;
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }

    private void addErrorMarker(IProject project, String message) {
        this.markerManager.addMarker((IResource)project, PORTLET_CONFIGURATION_ERROR_MARKER_ID, message, -1, 2);
    }
}

