/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.ui.widget.ITreeViewerBackup;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeViewerBackup
implements ITreeViewerBackup {
    protected List leafList = new ArrayList();

    public void restoreBackup(TreeViewer treeviewer) {
        int i = 0;
        while (i < this.leafList.size()) {
            treeviewer.expandToLevel(this.leafList.get(i), 1);
            ++i;
        }
    }

    public void dispose() {
        this.leafList.clear();
    }

    public void updateCollapsedStatus(TreeViewer treeViewer, Object data) {
        if (!"macosx".equalsIgnoreCase(Platform.getOS())) {
            treeViewer.collapseToLevel(data, -1);
        }
        this.updateStatus(treeViewer);
    }

    public void updateStatus(TreeViewer treeViewer) {
        TreePath[] treepaths = treeViewer.getExpandedTreePaths();
        List<TreePath> list = Arrays.asList(treepaths);
        this.leafList.clear();
        this.leafList.addAll(list);
        int i = 0;
        while (i < this.leafList.size()) {
            TreePath path = ((TreePath)this.leafList.get(i)).getParentPath();
            if (path == null) {
                this.leafList.remove(i);
                --i;
            }
            if (this.leafList.contains(path)) {
                this.leafList.remove(path);
                --i;
            }
            ++i;
        }
    }

    public void updateExpandedStatus(TreeViewer treeViewer, Object data) {
        treeViewer.expandToLevel(data, 1);
        this.updateStatus(treeViewer);
    }
}

