/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SelectParameterDefaultValueDialog
extends BaseDialog {
    private TableViewer tableViewer = null;
    private Table table = null;
    private Object[] selectedItems = null;
    private int[] selectedIndices = null;
    private int sortDir = 128;
    private List<Object> columnValueList = new ArrayList<Object>();
    private final String nullValueDispaly = Messages.getString((String)"SelectValueDialog.SelectValue.NullValue");
    private int expectedColumnDataType;
    private static DateFormatter formatter = new DateFormatter(ULocale.US);

    public SelectParameterDefaultValueDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public void setColumnValueList(Collection valueList, String dateType) {
        this.columnValueList.clear();
        this.columnValueList.addAll(valueList);
        this.expectedColumnDataType = DataAdapterUtil.modelDataTypeToCoreDataType((String)dateType);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(composite, 66306);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(Messages.getString((String)"SelectValueDialog.selectValue"));
        column.setWidth(data.widthHint);
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, Messages.getString((String)"SelectValueDialog.retrieving"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectParameterDefaultValueDialog.this.sortDir = SelectParameterDefaultValueDialog.this.sortDir == 128 ? 1024 : 128;
                SelectParameterDefaultValueDialog.this.table.setSortDirection(SelectParameterDefaultValueDialog.this.sortDir);
                SelectParameterDefaultValueDialog.this.tableViewer.setSorter((ViewerSorter)new TableSorter(SelectParameterDefaultValueDialog.this.sortDir));
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectParameterDefaultValueDialog.this.table.getSelectionCount() > 0) {
                    SelectParameterDefaultValueDialog.this.okPressed();
                }
            }
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectParameterDefaultValueDialog.this.populateList();
            }
        });
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.SelectParameterDefaultValueDialog_ID");
        return composite;
    }

    protected void okPressed() {
        this.selectedIndices = this.table.getSelectionIndices();
        if (this.columnValueList.get(this.selectedIndices[0]) == null) {
            this.setResult(null);
        } else {
            this.selectedItems = new Object[this.table.getSelectionCount()];
            int i = 0;
            while (i < this.table.getSelectionCount()) {
                this.selectedItems[i] = this.table.getSelection()[i].getData();
                ++i;
            }
            this.setResult(this.table.getSelection());
        }
        super.okPressed();
    }

    private void populateList() {
        try {
            if (this.getShell() == null || this.getShell().isDisposed()) {
                return;
            }
            if (this.getOkButton() != null && !this.getOkButton().isDisposed()) {
                this.getOkButton().setEnabled(false);
            }
            this.table.removeAll();
            this.table.deselectAll();
            this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            if (this.columnValueList != null) {
                this.tableViewer.setInput(this.columnValueList);
            } else {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
            }
            if (this.table.getItemCount() > 0) {
                this.table.select(0);
                this.getOkButton().setEnabled(true);
            }
            int i = 0;
            while (i < this.table.getItemCount()) {
                this.table.getItem(i).setData(this.columnValueList.get(i));
                ++i;
            }
            this.table.setSortColumn(this.table.getColumn(0));
            this.table.setSortDirection(this.sortDir);
            this.tableViewer.setSorter((ViewerSorter)new TableSorter(this.sortDir));
            this.table.setSelection(0);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public String[] getSelectedValue() {
        String[] exprValues = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            exprValues = new String[this.selectedIndices.length];
            int i = 0;
            while (i < this.selectedIndices.length) {
                exprValues[i] = this.selectedItems[i] == null ? "null" : this.getDataText(this.selectedItems[i]);
                ++i;
            }
        }
        return exprValues;
    }

    private String getDataText(Object element) {
        if (element != null) {
            if (this.expectedColumnDataType == 9 && element instanceof Date) {
                formatter.applyPattern("yyyy-MM-dd");
                return formatter.format((Date)element);
            }
            if (this.expectedColumnDataType == 10 && element instanceof Date) {
                formatter.applyPattern("HH:mm:ss.SSS");
                return formatter.format((Date)element);
            }
            if (this.expectedColumnDataType == 6 && element instanceof Date) {
                formatter.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                return formatter.format((Date)element);
            }
            try {
                return DataTypeUtil.toString((Object)element);
            }
            catch (BirtException birtException) {
                return String.valueOf(element);
            }
        }
        return null;
    }

    public static class ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element != null) {
                    return SelectParameterDefaultValueDialog.this.getDataText(element);
                }
                return SelectParameterDefaultValueDialog.this.nullValueDispaly;
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class TableSorter
    extends ViewerSorter {
        private int sortDir;

        private TableSorter(int sortDir) {
            this.sortDir = sortDir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.sortDir == 128) {
                if (e1 instanceof Integer) {
                    return ((Integer)e1).compareTo((Integer)e2);
                }
                if (e1 instanceof Double) {
                    return ((Double)e1).compareTo((Double)e2);
                }
                if (e1 instanceof BigDecimal) {
                    return ((BigDecimal)e1).compareTo((BigDecimal)e2);
                }
                if (SelectParameterDefaultValueDialog.this.getDataText(e1) != null) {
                    return SelectParameterDefaultValueDialog.this.getDataText(e1).compareTo(SelectParameterDefaultValueDialog.this.getDataText(e2));
                }
            } else if (this.sortDir == 1024) {
                if (e2 instanceof Integer) {
                    return ((Integer)e2).compareTo((Integer)e1);
                }
                if (e2 instanceof Double) {
                    return ((Double)e2).compareTo((Double)e1);
                }
                if (e2 instanceof BigDecimal) {
                    return ((BigDecimal)e2).compareTo((BigDecimal)e1);
                }
                if (SelectParameterDefaultValueDialog.this.getDataText(e2) != null) {
                    return SelectParameterDefaultValueDialog.this.getDataText(e2).compareTo(SelectParameterDefaultValueDialog.this.getDataText(e1));
                }
            }
            return 0;
        }
    }
}

