/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.IParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.parameters.ScalarParameter;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractParameterControlHelper
implements IParameterControlHelper {
    protected Composite parent;
    protected ScalarParameter parameter;
    protected boolean isRequired = false;
    protected boolean needTypeCheck = false;
    protected String paramterHandleName;
    protected boolean isStringType = false;
    protected Map<String, Object> lastConfigValues = new HashMap<String, Object>();
    protected Object defaultValue;
    protected Label controlLabel;
    protected InputParameterDialog parameterDialog;

    public AbstractParameterControlHelper(InputParameterDialog dialog) {
        this.parameterDialog = dialog;
    }

    @Override
    public void createControl(Composite parent, Object para, Object lastValue) {
        this.parent = parent;
        this.init(para, lastValue);
        this.prepare();
        this.createControlLabel();
        this.createParameterControl();
    }

    protected abstract void createParameterControl();

    protected void prepare() {
    }

    private void initLastValue(Object lastValue) {
        if (lastValue != null) {
            this.lastConfigValues.put(this.paramterHandleName, lastValue);
        }
    }

    @Override
    public Map<String, Object> getResults() {
        return this.lastConfigValues;
    }

    @Override
    public boolean validate() {
        return this.validateRequiredItem() && this.validateDataType();
    }

    private boolean validateRequiredItem() {
        Object paramterValue;
        if (this.isRequired && ((paramterValue = this.lastConfigValues.get(this.paramterHandleName)) == null || paramterValue instanceof String && StringUtil.isBlank((String)((String)paramterValue)) || paramterValue instanceof Object[] && ((Object[])paramterValue).length == 0)) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)"Error", (String)Messages.getFormattedString((String)"InputParameterDialog.err.requiredParam", (Object[])new String[]{this.paramterHandleName}));
            return false;
        }
        return true;
    }

    private boolean validateDataType() {
        if (this.needTypeCheck) {
            Object paramValue = this.lastConfigValues.get(this.paramterHandleName);
            try {
                Object obj = this.parameter.converToDataType(paramValue);
                this.lastConfigValues.put(this.paramterHandleName, obj);
            }
            catch (BirtException birtException) {
                MessageDialog.openError((Shell)this.parent.getShell(), (String)Messages.getString((String)"InputParameterDialog.err.invalidValueTitle"), (String)Messages.getFormattedString((String)"InputParameterDialog.err.invalidValue", (Object[])new String[]{paramValue.toString(), this.parameter.getHandle().getDataType()}));
                return false;
            }
        }
        return true;
    }

    private void init(Object para, Object lastValue) {
        this.parameter = (ScalarParameter)para;
        this.paramterHandleName = this.parameter.getHandle().getName();
        this.isRequired = this.parameter.getHandle().isRequired();
        this.isStringType = this.parameter.getHandle().getDataType().equals("string");
        this.initLastValue(lastValue);
        this.prepareControlDefaultValue();
    }

    private void createControlLabel() {
        this.controlLabel = new Label(this.parent, 0);
        this.controlLabel.setText(String.valueOf(this.parameter.getHandle().getDisplayLabel()) + (this.isRequired ? ": *" : ":"));
    }

    private void prepareControlDefaultValue() {
        this.defaultValue = this.getPreSetValue();
    }

    private Object getPreSetValue() {
        Object value = null;
        if (this.parameter.getDefaultValues().size() > 0) {
            value = this.parameter.getDefaultValues().get(0);
        }
        if (this.lastConfigValues.containsKey(this.paramterHandleName) && (value = this.lastConfigValues.get(this.paramterHandleName)) != null) {
            this.parameter.setSelectionValue(value);
        }
        return value;
    }

    protected String getFormatLabelString(IParameterSelectionChoice choice, ScalarParameter para) {
        Object value = choice.getValue();
        String label = choice.getLabel();
        if (label == null && value != null) {
            label = value instanceof Date ? this.formatDate2String(value) : String.valueOf(value);
        }
        label = this.formatString(label, para);
        return label;
    }

    private String formatDate2String(Object value) {
        String result = value.toString();
        try {
            result = DataTypeUtil.toString((Object)value);
        }
        catch (BirtException birtException) {}
        return result;
    }

    protected String formatString(String str, ScalarParameter para) {
        if (StringUtil.isBlank((String)str)) {
            return "";
        }
        ScalarParameterHandle paraHandle = para.getHandle();
        String formatPattern = this.convertFormatPattern(paraHandle);
        ULocale formatLocale = this.cvonvertFormatLocale(paraHandle);
        String type = paraHandle.getDataType();
        if (formatPattern == null) {
            return str;
        }
        String formatStr = "";
        try {
            if ("string".equals(type)) {
                formatStr = new StringFormatter(formatPattern, formatLocale).format(str);
            } else if ("dateTime".equals(type)) {
                formatPattern = formatPattern.equals("Unformatted") ? "DateTimeUnformatted" : formatPattern;
                formatStr = new DateFormatter(formatPattern, formatLocale).format((Date)para.converToDataType(str));
            } else if ("date".equals(type)) {
                formatPattern = formatPattern.equals("Unformatted") ? "DateUnformatted" : formatPattern;
                formatStr = new DateFormatter(formatPattern, formatLocale).format((Date)para.converToDataType(str));
            } else if ("time".equals(type)) {
                formatPattern = formatPattern.equals("Unformatted") ? "TimeUnformatted" : formatPattern;
                formatStr = new DateFormatter(formatPattern, formatLocale).format((Date)para.converToDataType(str));
            } else if ("decimal".equals(type) || "float".equals(type)) {
                double value = Double.parseDouble(str);
                if (Double.isInfinite(value)) {
                    formatStr = str;
                } else {
                    if ("Unformatted".equals(formatPattern)) {
                        formatPattern = null;
                    }
                    formatStr = new NumberFormatter(formatPattern, formatLocale).format(value);
                }
            } else if ("integer".equals(type)) {
                int value = Integer.parseInt(str);
                formatStr = new NumberFormatter(formatPattern, formatLocale).format((long)value);
            }
        }
        catch (Exception exception) {
            formatStr = str;
        }
        if (formatStr == null) {
            return str;
        }
        return UIUtil.convertToGUIString(formatStr);
    }

    private String convertFormatPattern(ScalarParameterHandle paraHandle) {
        String formatCategroy = paraHandle.getCategory();
        String formatPattern = paraHandle.getPattern();
        formatPattern = this.isCustom(formatCategroy) ? formatPattern : formatCategroy;
        return formatPattern;
    }

    private ULocale cvonvertFormatLocale(ScalarParameterHandle paraHandle) {
        ULocale formatLocale = null;
        Object formatValue = paraHandle.getProperty("format");
        if (formatValue instanceof FormatValue) {
            PropertyHandle propHandle = paraHandle.getPropertyHandle("format");
            FormatValue formatValueToSet = (FormatValue)formatValue;
            FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
            formatLocale = formatHandle.getLocale();
        }
        if (formatLocale == null) {
            formatLocale = ULocale.getDefault();
        }
        return formatLocale;
    }

    private boolean isCustom(String formatCategroy) {
        return "Custom".equals(formatCategroy) || "Custom".equals(formatCategroy) || "Custom".equals(formatCategroy) || "Custom".equals(formatCategroy) || "Custom".equals(formatCategroy) || "Currency".equals(formatCategroy);
    }
}

