/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class MenuButton
extends Composite {
    private Button button;
    private String text;
    private Image image;
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static int DRAW_FLAGS = 15;
    private static final int MARGIN_GAP = 4;
    private static final int TRIANGLE_WIDTH = 5;
    private static final int WIDTH_MORE = 14;
    private Point defaultSize = new Point(0, 0);
    private boolean isFixed = true;
    private boolean mouseSelection = false;
    private boolean mouseDown = false;
    private Menu menu;
    private List listeners;

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setText(String text) {
        this.text = text;
        this.button.setText("");
        this.layoutControl();
    }

    public void setToolTipText(String string) {
        this.button.setToolTipText(string);
    }

    private void layoutControl() {
        this.getParent().layout();
        this.button.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int imageWidth;
        int height;
        Button tmp = new Button((Composite)this, this.button.getStyle());
        if (this.text != null) {
            tmp.setText(this.text);
            height = tmp.computeSize((int)-1, (int)-1).y;
        } else {
            tmp.setText("");
            height = tmp.computeSize((int)-1, (int)-1).y;
        }
        if (this.image != null) {
            tmp.setImage(this.image);
        }
        Point size = tmp.computeSize(-1, -1);
        tmp.dispose();
        int width = this.menu != null ? size.x + 14 : size.x;
        if (this.isFixed && this.image != null && (imageWidth = this.image.getImageData().width) > 16) {
            width -= imageWidth - 16;
        }
        if (!this.isFixed) {
            height = size.y;
        }
        this.defaultSize = new Point(width, height);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void setImage(Image image) {
        this.image = image;
        this.layoutControl();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.button.setBackground(color);
        this.button.redraw();
    }

    public void setForeground(Color color) {
        super.setBackground(color);
        this.button.setForeground(color);
        this.button.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.button.setFont(font);
        this.button.redraw();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.button.setEnabled(enable);
        this.button.redraw();
    }

    public MenuButton(Composite parent, int style) {
        this(parent, style, false);
    }

    public MenuButton(Composite parent, int style, boolean fixed) {
        super(parent, 0x20000000);
        this.isFixed = fixed;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.button = new Button(this, style | 0x20000000){

            protected void checkSubclass() {
            }

            public String getText() {
                String text = MenuButton.this.getText();
                return text == null ? "" : text;
            }
        };
        GridData gd = new GridData(1808);
        this.button.setLayoutData((Object)gd);
        this.button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MenuButton.this.paintControl(e);
            }
        });
        this.button.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (!MenuButton.this.button.isEnabled() || e.button != 1 || !MenuButton.this.mouseDown) {
                    return;
                }
                MenuButton.this.mouseDown = false;
                MenuButton.this.mouseSelection = true;
                Rectangle size = MenuButton.this.button.getBounds();
                if (!size.contains(e.x, e.y)) {
                    return;
                }
                int left = 17;
                if (MenuButton.this.menu == null) {
                    left = 0;
                }
                if (e.x < size.width - left) {
                    if (MenuButton.this.listeners == null) {
                        return;
                    }
                    e.widget = MenuButton.this;
                    int i = 0;
                    while (i < MenuButton.this.listeners.size()) {
                        ((SelectionListener)MenuButton.this.listeners.get(i)).widgetSelected(new SelectionEvent(e));
                        ++i;
                    }
                } else if (MenuButton.this.menu != null) {
                    MenuButton.this.menu.setLocation(MenuButton.this.button.toDisplay(new Point(0, size.height - 1)));
                    MenuButton.this.menu.setVisible(true);
                }
            }
        });
        this.button.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (!MenuButton.this.button.isEnabled() || e.button != 1) {
                    return;
                }
                MenuButton.this.mouseSelection = true;
                Rectangle size = MenuButton.this.button.getBounds();
                if (!size.contains(e.x, e.y)) {
                    return;
                }
                MenuButton.this.mouseDown = true;
            }
        });
        this.button.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if ((e.keyCode == 0x1000002 || e.keyCode == 0x1000001) && MenuButton.this.menu != null) {
                    Rectangle size = MenuButton.this.button.getBounds();
                    MenuButton.this.menu.setLocation(MenuButton.this.button.toDisplay(new Point(0, size.height - 1)));
                    MenuButton.this.menu.setVisible(true);
                }
            }
        });
        this.button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (MenuButton.this.mouseSelection) {
                    MenuButton.this.mouseSelection = false;
                    return;
                }
                if (MenuButton.this.listeners == null) {
                    return;
                }
                e.widget = MenuButton.this;
                int i = 0;
                while (i < MenuButton.this.listeners.size()) {
                    ((SelectionListener)MenuButton.this.listeners.get(i)).widgetSelected(new SelectionEvent(e));
                    ++i;
                }
            }
        });
    }

    public void setDropDownMenu(Menu menu) {
        this.menu = menu;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    protected void paintControl(PaintEvent e) {
        e.gc.setFont(this.getFont());
        Color fg = this.isEnabled() ? this.getForeground() : new Color(e.gc.getDevice(), UIUtil.blend(this.getBackground().getRGB(), this.getForeground().getRGB(), 70));
        try {
            int imageHeight;
            e.gc.setForeground(fg);
            Color bgColor = e.gc.getBackground();
            e.gc.setBackground(e.gc.getForeground());
            Rectangle size = this.button.getBounds();
            if (this.menu != null) {
                Rectangle rect = new Rectangle(size.width - 12, 0, 5, size.height);
                UIUtil.drawArrow(e.gc, rect, 1024);
            }
            e.gc.setBackground(bgColor);
            int height = e.gc.textExtent((String)"", (int)MenuButton.DRAW_FLAGS).y;
            if (!this.isFixed && this.image != null && height < (imageHeight = this.image.getImageData().height)) {
                height = imageHeight;
            }
            if (this.defaultSize.y > size.height) {
                height = e.gc.textExtent((String)"", (int)MenuButton.DRAW_FLAGS).y > (height -= this.defaultSize.y - size.height) ? e.gc.textExtent((String)"", (int)MenuButton.DRAW_FLAGS).y : height;
            }
            int left = 17;
            if (this.menu == null) {
                left = 3;
            }
            if (this.menu != null) {
                Color fgColor = e.gc.getForeground();
                e.gc.setForeground(this.getDisplay().getSystemColor(18));
                e.gc.drawLine(size.width - left, (size.height - height) / 2, size.width - left, (size.height - height) / 2 + height);
                e.gc.setForeground(fgColor);
            }
            if (this.text != null && this.text.trim().length() > 0) {
                int width = e.gc.textExtent((String)this.text, (int)MenuButton.DRAW_FLAGS).x;
                int fontHeight = e.gc.textExtent((String)this.text, (int)MenuButton.DRAW_FLAGS).y;
                e.gc.drawText(this.text, (size.width - (left += 4 + width)) / 2 + 4, (size.height - fontHeight) / 2, DRAW_FLAGS | 1);
            }
            if (this.image != null) {
                int imageWidth = this.image.getImageData().width;
                int imageHeight2 = this.image.getImageData().height;
                Image imageTemp = null;
                if (!this.isEnabled()) {
                    imageTemp = new Image(e.gc.getDevice(), this.image, 1);
                }
                if (this.isFixed) {
                    imageWidth = imageWidth > 16 ? 16 : imageWidth;
                    imageHeight2 = imageHeight2 > 16 ? 16 : imageHeight2;
                }
                left += 4 + imageWidth;
                if (!this.isEnabled()) {
                    e.gc.drawImage(imageTemp, 0, 0, imageTemp.getImageData().width, imageTemp.getImageData().height, (size.width - left) / 2 + 4, Math.round((float)(size.height - imageHeight2) / 2.0f), imageWidth, imageHeight2);
                    imageTemp.dispose();
                } else {
                    e.gc.drawImage(this.image, 0, 0, this.image.getImageData().width, this.image.getImageData().height, (size.width - left) / 2 + 4, Math.round((float)(size.height - imageHeight2) / 2.0f), imageWidth, imageHeight2);
                }
            }
        }
        finally {
            if (!this.isEnabled() && fg != null) {
                fg.dispose();
            }
        }
    }
}

