/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.processor;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionWizard;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.processor.AbstractElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class TableGridProcessor
extends AbstractElementProcessor {
    TableGridProcessor(String elementType) {
        super(elementType);
    }

    public DesignElementHandle createElement(Object extendedData) {
        boolean isTable = "Table".equals(this.getElementType());
        if (isTable) {
            TableOptionWizard wizard = new TableOptionWizard();
            WizardDialog dialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)wizard);
            dialog.setHelpAvailable(true);
            if (dialog.open() == 0) {
                Object[] result = wizard.getResult();
                Object[] data = (Object[])result[0];
                boolean isSummaryTable = data.length > 2 && data[2] != null && (Boolean)data[2] != false;
                TableHandle table = DesignElementFactory.getInstance().newTableItem(null, (Integer)data[1], 1, isSummaryTable ? 0 : (Integer)data[0], 1);
                InsertInLayoutUtil.setInitWidth(table);
                Object[] datasetInfo = (Object[])result[1];
                if (datasetInfo != null && datasetInfo[0] != null) {
                    try {
                        DataSetHandle dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(datasetInfo[0].toString());
                        if (dataSet != null) {
                            table.setDataSet(dataSet);
                        } else {
                            new LinkedDataSetAdapter().setLinkedDataModel((ReportItemHandle)table, datasetInfo[0].toString());
                        }
                        DataSetColumnBindingsFormHandleProvider provider = new DataSetColumnBindingsFormHandleProvider();
                        provider.setBindingObject((ReportElementHandle)table);
                        if (datasetInfo[1] instanceof Object[]) {
                            provider.generateBindingColumns((Object[])datasetInfo[1]);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                }
                if (isSummaryTable) {
                    try {
                        table.setIsSummaryTable(((Boolean)data[2]).booleanValue());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                return table;
            }
        } else {
            TableOptionDialog dialog = new TableOptionDialog(UIUtil.getDefaultShell(), isTable);
            if (dialog.open() == 0 && dialog.getResult() instanceof Object[]) {
                Object[] data = (Object[])dialog.getResult();
                GridHandle handle = DesignElementFactory.getInstance().newGridItem(TableGridProcessor.getNewName(extendedData), (Integer)data[1], (Integer)data[0]);
                InsertInLayoutUtil.setInitWidth(handle);
                return handle;
            }
        }
        return null;
    }

    public boolean editElement(DesignElementHandle handle) {
        return false;
    }
}

