/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TextFigure;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.TextEditor;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.draw2d.IFigure;

public class TextEditPart
extends LabelEditPart {
    private static final String FIGURE_DEFAULT_TEXT = Messages.getString((String)"TextEditPart.Figure.Dafault");
    private static final String TEXT_TRANS_MSG = Messages.getString((String)"TextEditPart.trans.editText");

    public TextEditPart(Object model) {
        super(model);
    }

    public void performDirectEdit() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(TEXT_TRANS_MSG);
        String title = TextEditor.DLG_TITLE_EDIT;
        TextEditor dialog = new TextEditor(UIUtil.getDefaultShell(), title, (TextItemHandle)this.getModel());
        dialog.setEditModal(true);
        if (dialog.open() == 0) {
            stack.commit();
            this.refreshVisuals();
        } else {
            stack.rollback();
        }
    }

    protected IFigure createFigure() {
        TextFigure text = new TextFigure();
        return text;
    }

    public void refreshFigure() {
        super.refreshFigure();
        ((LabelFigure)this.getFigure()).setToolTipText(((TextItemHandle)this.getModel()).getDisplayContent());
    }

    protected String getText() {
        TextItemHandle handle = (TextItemHandle)this.getModel();
        String text = handle.getDisplayContent();
        if (text == null || text.length() == 0) {
            text = FIGURE_DEFAULT_TEXT;
        } else if (text.length() > 18 && "html".equals(handle.getContentType())) {
            text = String.valueOf(text.substring(0, 16)) + "...";
        }
        return text;
    }

    protected boolean hasText() {
        return !StringUtil.isBlank((String)((TextItemHandle)this.getModel()).getDisplayContent());
    }
}

