/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.layer.TableBorderLayer;
import org.eclipse.birt.report.designer.internal.ui.layout.FixTableLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractTableEditPart
extends ReportElementEditPart
implements LayerConstants,
ITableLayoutOwner {
    public static final String BORDER_LAYER = "Table Border layer";
    protected FreeformLayeredPane innerLayers;
    protected LayeredPane printableLayers;

    public AbstractTableEditPart(Object model) {
        super(model);
    }

    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.innerLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.printableLayers == null) {
            return null;
        }
        return this.printableLayers.getLayer(key);
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        FreeformLayer layer = new FreeformLayer();
        layer.setLayoutManager((LayoutManager)new TableLayout(this));
        layeredPane.add((IFigure)layer, (Object)"Primary Layer");
        layeredPane.add((IFigure)new TableBorderLayer(this), (Object)BORDER_LAYER);
        return layeredPane;
    }

    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    public void reLayout() {
        this.notifyModelChange();
        this.getFigure().invalidateTree();
        this.getFigure().revalidate();
    }

    public abstract AbstractCellEditPart getCell(int var1, int var2);

    protected void contentChange(Map info) {
        int intValue;
        Object action = info.get("Content event type");
        if (action instanceof Integer && ((intValue = ((Integer)action).intValue()) == 10 || intValue == 12 || intValue == 11)) {
            if (((ReportItemHandle)this.getModel()).getViews().size() > 0) {
                final Object tempModel = this.getModel();
                final DeferredGraphicalViewer viewer = (DeferredGraphicalViewer)this.getViewer();
                this.markDirty(true);
                EditPart part = this.getParent();
                ((ReportElementEditPart)this.getParent()).removeChild((EditPart)this);
                part.refresh();
                this.removeGuideFeedBack();
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        Object part = viewer.getEditPartRegistry().get(tempModel);
                        if (part != null) {
                            viewer.setSelection((ISelection)new StructuredSelection(part));
                        }
                    }
                });
                return;
            }
            ((ReportElementEditPart)this.getParent()).contentChange(info);
            return;
        }
        ArrayList old = new ArrayList(this.getChildren());
        super.contentChange(info);
        List newChildren = this.getChildren();
        int i = 0;
        while (i < old.size()) {
            if (newChildren.contains(old.get(i))) {
                ((AbstractCellEditPart)old.get(i)).updateExistPart();
            }
            ++i;
        }
    }

    protected void updateLayoutPreference() {
        super.updateLayoutPreference();
        if (!(((DesignElementHandle)this.getModel()).getModuleHandle() instanceof ReportDesignHandle)) {
            return;
        }
        ReportDesignHandle handle = (ReportDesignHandle)((DesignElementHandle)this.getModel()).getModuleHandle();
        String str = handle.getLayoutPreference();
        if ("auto layout".equals(str)) {
            this.getContentPane().setLayoutManager((LayoutManager)new TableLayout(this));
        } else if ("fixed layout".equals(str)) {
            this.getContentPane().setLayoutManager((LayoutManager)new FixTableLayout(this));
        }
    }

    public int getFixAllowMinRowHight() {
        return 1;
    }
}

