/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventFilter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventManager;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ListenerElementVisitor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;

public class ModelEventManager
implements Listener,
IModelEventManager {
    private boolean isPost = false;
    private List listenerList = new ArrayList();
    private ListenerElementVisitor visitor;
    private Object root;
    private ActivityStackListener commandStackListener = new ActivityStackListener(){

        public void stackChanged(ActivityStackEvent event) {
            ModelEventManager.this.postEvent(event);
        }
    };

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        ArrayList temp = new ArrayList(this.listenerList);
        int size = temp.size();
        int i = 0;
        while (i < size) {
            IModelEventProcessor processor = (IModelEventProcessor)temp.get(i);
            if (processor instanceof IFastConsumerProcessor && ((IFastConsumerProcessor)processor).isOverdued()) {
                this.listenerList.remove(processor);
            } else {
                Object filter = processor.getAdapter(IModelEventFilter.class);
                if (!(filter instanceof IModelEventFilter) || !((IModelEventFilter)filter).filterModelEvent(focus, ev)) {
                    processor.addElementEvent(focus, ev);
                }
            }
            ++i;
        }
        this.getListenerElementVisitor().addListener(focus);
    }

    private void postEvent(ActivityStackEvent event) {
        ArrayList temp = new ArrayList(this.listenerList);
        int size = temp.size();
        int i = 0;
        while (i < size) {
            IModelEventProcessor processor = (IModelEventProcessor)temp.get(i);
            if (processor instanceof IFastConsumerProcessor && ((IFastConsumerProcessor)processor).isOverdued()) {
                this.listenerList.remove(processor);
            }
            ++i;
        }
        this.checkStatus();
        switch (event.getAction()) {
            case 1: 
            case 2: 
            case 3: {
                this.postModelEvent();
                break;
            }
            case 4: {
                this.clearEvent();
                break;
            }
        }
    }

    protected void postModelEvent() {
        try {
            try {
                ArrayList post = new ArrayList(this.listenerList);
                this.isPost = true;
                int size = post.size();
                int i = 0;
                while (i < size) {
                    IModelEventProcessor processor = (IModelEventProcessor)post.get(i);
                    processor.postElementEvent();
                    ++i;
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
                this.isPost = false;
            }
        }
        finally {
            this.isPost = false;
        }
    }

    protected void clearEvent() {
        int size = this.listenerList.size();
        ArrayList list = new ArrayList(this.listenerList);
        int i = 0;
        while (i < size) {
            IModelEventProcessor processor = (IModelEventProcessor)list.get(i);
            processor.clear();
            ++i;
        }
    }

    private void checkStatus() {
        if (this.isPost) {
            throw new RuntimeException("The event is post now");
        }
    }

    public void addModelEventProcessor(IModelEventProcessor processor) {
        if (!this.listenerList.contains(processor)) {
            this.listenerList.add(processor);
        }
    }

    public void removeModelEventProcessor(IModelEventProcessor processor) {
        this.listenerList.remove(processor);
    }

    public void dispose() {
        this.listenerList.clear();
        if (this.root instanceof DesignElementHandle) {
            this.visitor.removeListener((DesignElementHandle)this.root);
        }
        this.root = null;
        this.visitor = null;
    }

    private ListenerElementVisitor getListenerElementVisitor() {
        if (this.visitor == null) {
            this.visitor = new ListenerElementVisitor(this);
        }
        return this.visitor;
    }

    public void hookCommandStack(WrapperCommandStack stack) {
        if (stack != null) {
            stack.addCommandStackListener(this.commandStackListener);
        }
    }

    public void unhookCommandStack(WrapperCommandStack stack) {
        if (stack != null) {
            stack.removeCommandStackListener(this.commandStackListener);
        }
    }

    public void hookRoot(Object obj) {
        if (this.root == obj) {
            return;
        }
        this.unhookRoot(this.root);
        if (obj instanceof DesignElementHandle) {
            this.getListenerElementVisitor().addListener((DesignElementHandle)((DesignElementHandle)obj).getModuleHandle());
        }
        this.root = obj;
    }

    public void unhookRoot(Object obj) {
        if (obj instanceof DesignElementHandle) {
            this.getListenerElementVisitor().removeListener((DesignElementHandle)obj);
        }
    }
}

