/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectionChoiceDialog
extends BaseDialog {
    private Text labelEditor;
    private Text valueEditor;
    private SelectionChoice selectionChoice;
    private CLabel messageLine;
    private ISelectionChoiceValidator validator;
    private Text resourceText;
    private Button removeBtn;
    private static final String EMPTY_STRING = "";
    public static final String SELECTON_CHOICE_HELPER_KEY = "Selection Choice Dialog Helper";
    public static final String VALUE = "Value";
    public static final String CAN_EMPTY = "Can Use Empty";
    public static final String CAN_NULL = "Can Use NULL";
    private boolean canUseEmptyValue = false;
    private boolean canUseNullValue = false;
    private IDialogHelper helper;

    public SelectionChoiceDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public SelectionChoiceDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public SelectionChoiceDialog(String title, boolean canUseNullValue, boolean canUseEmptyValue) {
        this(title);
        this.canUseEmptyValue = canUseEmptyValue;
        this.canUseNullValue = canUseNullValue;
    }

    protected boolean initDialog() {
        Assert.isNotNull((Object)this.selectionChoice);
        this.labelEditor.setText(UIUtil.convertToGUIString(this.selectionChoice.getLabel()));
        this.resourceText.setText(UIUtil.convertToGUIString(this.selectionChoice.getLabelResourceKey()));
        if (this.validator != null) {
            this.updateStatus();
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String[] labels = new String[]{Messages.getString((String)"ParameterDialog.SelectionDialog.Label.DisplayTextKey"), Messages.getString((String)"ParameterDialog.SelectionDialog.Label.DisplayText"), Messages.getString((String)"ParameterDialog.SelectionDialog.Label.Value")};
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(labels[0]);
        this.resourceText = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.minimumWidth = 200;
        this.resourceText.setLayoutData((Object)gd);
        this.resourceText.setEditable(false);
        Button resourceBtn = new Button(composite, 8);
        resourceBtn.setText(Messages.getString((String)"ParameterDialog.SelectionDialog.Button.Resource"));
        resourceBtn.setToolTipText(Messages.getString((String)"ParameterDialog.SelectionDialog.Button.Resource.Tooltip"));
        resourceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoiceDialog.this.handleBrowserSelectedEvent();
            }
        });
        resourceBtn.setEnabled(this.enableResourceKey());
        this.removeBtn = new Button(composite, 0);
        this.removeBtn.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_DELETE"));
        this.removeBtn.setToolTipText(Messages.getString((String)"ParameterDialog.SelectionDialog.Button.Remove.Tooltip"));
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoiceDialog.this.resourceText.setText(SelectionChoiceDialog.EMPTY_STRING);
                SelectionChoiceDialog.this.labelEditor.setText(SelectionChoiceDialog.EMPTY_STRING);
                SelectionChoiceDialog.this.updateRemoveBtnState();
            }
        });
        new Label(composite, 0).setText(labels[1]);
        this.labelEditor = new Text(composite, 2048);
        gd = new GridData(768);
        gd.minimumWidth = 200;
        gd.horizontalSpan = 3;
        this.labelEditor.setLayoutData((Object)gd);
        new Label(composite, 0).setText(labels[2]);
        this.createValuePart(composite);
        Composite noteContainer = new Composite(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = UIUtil.getMaxStringWidth(labels, (Control)composite) + 200 + layout.horizontalSpacing * 2 + resourceBtn.computeSize((int)-1, (int)-1).x;
        noteContainer.setLayoutData((Object)gd);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        noteContainer.setLayout((Layout)layout);
        Label note = new Label(noteContainer, 64);
        note.setText(Messages.getString((String)"ParameterDialog.SelectionDialog.Label.Note"));
        gd = new GridData(768);
        gd.minimumWidth = UIUtil.getMaxStringWidth(labels, (Control)composite) + 200 + layout.horizontalSpacing * 2 + resourceBtn.computeSize((int)-1, (int)-1).x;
        note.setLayoutData((Object)gd);
        this.messageLine = new CLabel(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.messageLine.setLayoutData((Object)gd);
        if (this.validator != null) {
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectionChoiceDialog.this.updateStatus();
                }
            };
            this.labelEditor.addModifyListener(listener);
            if (this.getValueControl() instanceof Text) {
                ((Text)this.getValueControl()).addModifyListener(listener);
            }
            if (this.getValueControl() instanceof Combo) {
                ((Combo)this.getValueControl()).addModifyListener(listener);
            }
            if (this.getValueControl() instanceof CCombo) {
                ((CCombo)this.getValueControl()).addModifyListener(listener);
            }
        }
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.SelectionChoiceDialog_ID");
        return composite;
    }

    protected void okPressed() {
        this.selectionChoice.setLabel(UIUtil.convertToModelString(this.labelEditor.getText(), false));
        this.selectionChoice.setValue(this.getValueValue());
        this.selectionChoice.setLabelResourceKey(UIUtil.convertToModelString(this.resourceText.getText(), false));
        this.setResult(this.selectionChoice);
        super.okPressed();
    }

    private void updateStatus() {
        String erroeMessage;
        if (this.helper != null) {
            this.helper.update(false);
        }
        if ((erroeMessage = this.validator.validate(UIUtil.convertToModelString(this.resourceText.getText(), false), UIUtil.convertToModelString(this.labelEditor.getText(), false), this.getValueValue())) != null) {
            this.messageLine.setText(erroeMessage);
            this.messageLine.setImage(ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK"));
            this.getOkButton().setEnabled(false);
        } else {
            this.messageLine.setText(EMPTY_STRING);
            this.messageLine.setImage(null);
            this.getOkButton().setEnabled(true);
        }
        this.updateRemoveBtnState();
    }

    public void setInput(SelectionChoice selectionChoice) {
        this.selectionChoice = selectionChoice;
    }

    public void setValidator(ISelectionChoiceValidator validator) {
        this.validator = validator;
    }

    private String[] getBaseNames() {
        List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
        if (resources == null) {
            return null;
        }
        return resources.toArray(new String[0]);
    }

    private URL[] getResourceURLs() {
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return null;
        }
        URL[] urls = new URL[baseNames.length];
        int i = 0;
        while (i < baseNames.length) {
            urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            ++i;
        }
        return urls;
    }

    private boolean enableResourceKey() {
        URL[] resources = this.getResourceURLs();
        String[] path = null;
        try {
            if (resources != null && resources.length > 0) {
                path = new String[resources.length];
                int i = 0;
                while (i < path.length) {
                    path[i] = DEUtil.getFilePathFormURL((URL)resources[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle(e);
        }
        if (resources == null || path == null || path.length == 0) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        while (i < path.length) {
            if (path[i] != null && new File(path[i]).exists()) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    protected void handleBrowserSelectedEvent() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURLs(this.getResourceURLs());
        if (dlg.open() == 0) {
            this.handleSelectedEvent((String[])dlg.getDetailResult());
        }
    }

    private void handleSelectedEvent(String[] values) {
        if (values.length == 2) {
            if (values[0] != null) {
                this.resourceText.setText(values[0]);
            }
            if (values[1] != null) {
                this.labelEditor.setText(values[1]);
            }
            this.updateRemoveBtnState();
        }
    }

    private void updateRemoveBtnState() {
        this.removeBtn.setEnabled(!this.resourceText.getText().equals(EMPTY_STRING));
    }

    private void createValuePart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters(this.selectionChoice, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && this.helper == null) {
                    this.helper = helperProvider.createHelper((Object)this, SELECTON_CHOICE_HELPER_KEY);
                    if (this.helper != null) {
                        this.helper.setProperty(VALUE, this.selectionChoice.getValue());
                        this.helper.setProperty(CAN_EMPTY, this.canUseEmptyValue);
                        this.helper.setProperty(CAN_NULL, this.canUseNullValue);
                        this.helper.createContent(parent);
                        this.helper.addListener(24, new Listener(){

                            public void handleEvent(Event event) {
                                SelectionChoiceDialog.this.helper.update(false);
                            }
                        });
                        this.helper.update(true);
                    }
                }
                ++i;
            }
        }
        if (this.helper == null) {
            this.valueEditor = new Text(parent, 2048);
            this.valueEditor.setText(UIUtil.convertToGUIString(this.selectionChoice.getValue()));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.valueEditor.setLayoutData((Object)gd);
            this.valueEditor.setFocus();
        } else {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.helper.getControl().setLayoutData((Object)gd);
            this.helper.getControl().setFocus();
        }
    }

    private Control getValueControl() {
        if (this.helper == null) {
            return this.valueEditor;
        }
        return this.helper.getControl();
    }

    private String getValueValue() {
        if (this.helper == null) {
            return this.valueEditor.getText();
        }
        return (String)this.helper.getProperty(VALUE);
    }

    public static interface ISelectionChoiceValidator {
        public String validate(String var1, String var2, String var3);
    }
}

