/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimeAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatLayoutPeer;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FormatDateTimeLayoutPeer
extends FormatLayoutPeer {
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatDateTimePage.label.general.preview.group");
    private static final String LABEL_CUSTOM_PREVIEW_DATETIME = Messages.getString((String)"FormatDateTimePage.label.preview.dateTime");
    private static final String ENTER_DATE_TIME_GUIDE_FORMAT = Messages.getString((String)"FormatDateTimePage.label.guide.format");
    private static final String ENTER_DATE_TIME_GUIDE_TEXT = Messages.getString((String)"FormatDateTimePage.label.guide.text");
    private static final String PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW = Messages.getString((String)"FormatDateTimePage.preview.invalid.dateTime");
    private static final int FORMAT_CODE_INDEX = 2;
    private Label generalPreviewLabel;
    private Date defaultDate = new Date();
    private String defaultPreviewText = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, ULocale.getDefault()).format(this.defaultDate);

    public FormatDateTimeLayoutPeer(int dateTimeType, int pageAlignment, boolean isFormStyle, boolean showLocale) {
        super(pageAlignment, isFormStyle, showLocale);
        this.formatAdapter = new FormatDateTimeAdapter(dateTimeType);
    }

    protected void fireFormatChanged(String newCategory, String newPattern, String newLocale) {
        this.fireFormatChanged("dateTimeFormat", newCategory, newPattern, newLocale);
    }

    protected void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put("Unformatted", this.getGeneralPage(parent));
        this.categoryPageMaps.put("General Date", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Long Date", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Medium Date", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Short Date", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Long Time", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Medium Time", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Short Time", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Custom", this.getCustomPage(parent, true, LABEL_CUSTOM_PREVIEW_DATETIME));
    }

    protected String getDefaultPreviewText() {
        return this.defaultPreviewText == null ? "" : this.defaultPreviewText;
    }

    protected String getCustomGuideText() {
        return ENTER_DATE_TIME_GUIDE_TEXT;
    }

    protected void initiatePageLayout(String categoryStr, String patternStr, String localeStr) {
        this.initiatePageLayout(((FormatDateTimeAdapter)this.formatAdapter).getCustomCategoryName(), categoryStr, patternStr, localeStr);
    }

    protected void reLayoutSubPages() {
        this.reLayoutSubPages(((FormatDateTimeAdapter)this.formatAdapter).getCustomCategoryName());
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.generalPreviewLabel = this.createGeneralPreviewPart(this.generalPage);
        }
        return this.generalPage;
    }

    private Label createGeneralPreviewPart(Composite parent) {
        Group group = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x1000300, this.isFormStyle);
        previewLabel.setLayoutData((Object)new GridData(1808));
        return previewLabel;
    }

    protected void createTable(Composite parent) {
        super.createTable(parent);
        ULocale locale = this.getLocale();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        TableColumn tableColumValue = new TableColumn(this.customFormatTable, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_NAME);
        tableColumValue.setWidth(90);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.customFormatTable, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(120);
        tableColumnDisplay.setResizable(true);
        TableColumn tableColumnFormatCode = new TableColumn(this.customFormatTable, 0);
        tableColumnFormatCode.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumnFormatCode.setWidth(120);
        tableColumnFormatCode.setResizable(true);
        String[][] items = this.getTableItems(locale);
        int i = 0;
        while (i < items.length) {
            new TableItem(this.customFormatTable, 0).setText(items[i]);
            ++i;
        }
        this.customFormatTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimeLayoutPeer.this.customFormatCodeTextBox.setText(((TableItem)e.item).getText(2));
                FormatDateTimeLayoutPeer.this.updatePreview();
                FormatDateTimeLayoutPeer.this.notifyFormatChange();
            }
        });
    }

    protected void setControlsEnabled(boolean enabled) {
        this.typeChoicer.setEnabled(enabled);
        this.localeChoicer.setEnabled(enabled);
        this.customFormatCodeTextBox.setEnabled(enabled);
        this.customPreviewTextBox.setEnabled(enabled);
        this.customFormatTable.setEnabled(enabled);
    }

    protected void setDefaultPreviewText(String text) {
        this.previewText = text == null || StringUtil.isBlank((String)text) ? null : text;
    }

    protected void updatePreview() {
        this.markDirty(this.hasLoaded);
        String category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText());
        this.setCategory(category);
        ULocale locale = FormatAdapter.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        boolean invalidPreviewText = false;
        Date sampleDateTime = this.defaultDate;
        if (this.getPreviewText() != null && !this.getPreviewText().equals(this.defaultPreviewText)) {
            try {
                sampleDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, locale).parse(this.getPreviewText());
            }
            catch (Exception exception) {
                invalidPreviewText = true;
            }
        }
        if (((FormatDateTimeAdapter)this.formatAdapter).getCustomCategoryName().equals(category)) {
            String fmtStr;
            String pattern = this.customFormatCodeTextBox.getText();
            if (invalidPreviewText) {
                fmtStr = PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW;
            } else {
                try {
                    fmtStr = pattern == null || pattern.length() == 0 ? this.defaultPreviewText : new DateFormatter(pattern, locale).format(sampleDateTime);
                }
                catch (Exception exception) {
                    fmtStr = PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW;
                }
            }
            this.customPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else {
            String pattern = null;
            if (!((FormatDateTimeAdapter)this.formatAdapter).getUnformattedCategoryDisplayName().equals(category)) {
                pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                this.setPattern(pattern);
            } else {
                pattern = ((FormatDateTimeAdapter)this.formatAdapter).getUnformattedCategoryName();
                this.setPattern(null);
            }
            String fmtStr = new DateFormatter(pattern, locale).format(sampleDateTime);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
        }
    }

    protected void updateTextByLocale() {
        ULocale oldLocale = FormatAdapter.getLocaleByDisplayName(this.locale);
        Date sampleDateTime = this.defaultDate;
        try {
            if (this.getPreviewText() != null) {
                sampleDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, oldLocale).parse(this.getPreviewText());
            }
        }
        catch (ParseException parseException) {}
        this.setLocale(this.localeChoicer.getText());
        ULocale locale = FormatAdapter.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        int index = this.typeChoicer.getSelectionIndex();
        this.typeChoicer.setItems(this.formatAdapter.getFormatTypes(locale));
        if (index >= 0 && index < this.typeChoicer.getItemCount()) {
            this.typeChoicer.select(index);
        }
        String[][] items = this.getTableItems(locale);
        int i = 0;
        while (i < items.length) {
            this.customFormatTable.getItem(i).setText(items[i]);
            ++i;
        }
        if (this.customFormatTable.getSelectionCount() == 1) {
            this.customFormatCodeTextBox.setText(this.customFormatTable.getSelection()[0].getText(2));
        }
        String sampleDateTimeString = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, locale).format(sampleDateTime);
        this.customPreviewTextBox.setText(sampleDateTimeString);
        this.setPreviewText(sampleDateTimeString);
    }

    private String[][] getTableItems(ULocale locale) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        String[][] items = new String[][]{{this.formatAdapter.getDisplayName4Category("General Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date"), locale).getFormatCode()}, {this.formatAdapter.getDisplayName4Category("Long Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date"), locale).getFormatCode()}, {this.formatAdapter.getDisplayName4Category("Medium Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date"), locale).getFormatCode()}, {this.formatAdapter.getDisplayName4Category("Short Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date"), locale).getFormatCode()}, {this.formatAdapter.getDisplayName4Category("Long Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time"), locale).getFormatCode()}, {this.formatAdapter.getDisplayName4Category("Medium Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time"), locale).getFormatCode()}, {this.formatAdapter.getDisplayName4Category("Short Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time"), locale).getFormatCode()}};
        itemList.addAll(Arrays.asList(items));
        String[] customPatterns = FormatDateTimePattern.getCustormPatternCategorys();
        int i = 0;
        while (i < customPatterns.length) {
            itemList.add(new String[]{FormatDateTimePattern.getDisplayName4CustomCategory((String)customPatterns[i]), new DateFormatter(FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i], (ULocale)locale), locale).format(this.defaultDate), FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i], (ULocale)locale)});
            ++i;
        }
        return (String[][])itemList.toArray((T[])new String[0][3]);
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return ((FormatDateTimeAdapter)this.formatAdapter).getUnformattedCategoryDisplayName();
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public void setPreviewText(String text) {
        this.setDefaultPreviewText(text);
        this.updatePreview();
    }
}

