/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;

public class DeleteRowHandler
extends SelectionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        TableEditPart part = this.getTableEditPart();
        if (part != null) {
            EditPartViewer viewer = part.getViewer();
            part.deleteRow(this.getRowNumbers());
            viewer.select((EditPart)part);
        }
        return Boolean.TRUE;
    }

    protected List getRowHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> rowHandles = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof DummyEditpart && ((DummyEditpart)obj).getModel() instanceof RowHandle) {
                rowHandles.add(((DummyEditpart)obj).getModel());
            }
            ++i;
        }
        return rowHandles;
    }

    protected int[] getRowNumbers() {
        List rowHandles = this.getRowHandles();
        if (rowHandles.isEmpty()) {
            return new int[0];
        }
        int size = rowHandles.size();
        int[] rowNumbers = new int[size];
        int i = 0;
        while (i < size) {
            rowNumbers[i] = this.getRowNumber(rowHandles.get(i));
            ++i;
        }
        int[] a = rowNumbers;
        Arrays.sort(a);
        return a;
    }

    public int getRowNumber(Object rowHandle) {
        return HandleAdapterFactory.getInstance().getRowHandleAdapter(rowHandle).getRowNumber();
    }
}

