/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.reference.IntReference;
import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;

public class SynchronizedInt
implements ModifiableIntReference,
Cloneable,
Serializable {
    private int value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedInt(int value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedInt(int value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedInt(Object mutex) {
        this(0, mutex);
    }

    public SynchronizedInt() {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEqual(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZero() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotZero() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGreaterThan(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value > v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGreaterThanOrEqual(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value >= v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLessThan(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value < v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLessThanOrEqual(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value <= v;
        }
    }

    public boolean isPositive() {
        return this.isGreaterThan(0);
    }

    public boolean isNotPositive() {
        return this.isLessThanOrEqual(0);
    }

    public boolean isNegative() {
        return this.isLessThan(0);
    }

    public boolean isNotNegative() {
        return this.isGreaterThanOrEqual(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int abs() {
        Object object = this.mutex;
        synchronized (object) {
            return Math.abs(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int neg() {
        Object object = this.mutex;
        synchronized (object) {
            return -this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value + v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subtract(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value - v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int multiply(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value * v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int divide(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value / v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainder(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value % v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int min(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return Math.min(this.value, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int max(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return Math.max(this.value, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double pow(int v) {
        Object object = this.mutex;
        synchronized (object) {
            return Math.pow(this.value, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setValue(int value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(value);
        }
    }

    private int setValue_(int v) {
        int old = this.value;
        return old == v ? old : this.setValue_(v, old);
    }

    private int setChangedValue_(int v) {
        return this.setValue_(v, this.value);
    }

    private int setValue_(int v, int old) {
        this.value = v;
        this.mutex.notifyAll();
        return old;
    }

    public int setZero() {
        return this.setValue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int increment() {
        Object object = this.mutex;
        synchronized (object) {
            ++this.value;
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrement() {
        Object object = this.mutex;
        synchronized (object) {
            --this.value;
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareAndSwap(int expectedValue, int newValue) {
        Object object = this.mutex;
        synchronized (object) {
            return this.compareAndSwap_(expectedValue, newValue);
        }
    }

    private int compareAndSwap_(int expectedValue, int newValue) {
        return this.value == expectedValue ? this.setValue_(newValue) : this.value;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEqual(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEqual_(v);
        }
    }

    private void waitUntilEqual_(int v) throws InterruptedException {
        while (this.value != v) {
            this.mutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotEqual(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotEqual_(v);
        }
    }

    private void waitUntilNotEqual_(int v) throws InterruptedException {
        while (this.value == v) {
            this.mutex.wait();
        }
    }

    public void waitUntilZero() throws InterruptedException {
        this.waitUntilEqual(0);
    }

    public void waitUntilNotZero() throws InterruptedException {
        this.waitUntilNotEqual(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilGreaterThan(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilGreaterThan_(v);
        }
    }

    private void waitUntilGreaterThan_(int v) throws InterruptedException {
        while (this.value <= v) {
            this.mutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilGreaterThanOrEqual(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilGreaterThanOrEqual_(v);
        }
    }

    private void waitUntilGreaterThanOrEqual_(int v) throws InterruptedException {
        while (this.value < v) {
            this.mutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilLessThan(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilLessThan_(v);
        }
    }

    private void waitUntilLessThan_(int v) throws InterruptedException {
        while (this.value >= v) {
            this.mutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilLessThanOrEqual(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilLessThanOrEqual_(v);
        }
    }

    private void waitUntilLessThanOrEqual_(int v) throws InterruptedException {
        while (this.value > v) {
            this.mutex.wait();
        }
    }

    public void waitUntilPositive() throws InterruptedException {
        this.waitUntilGreaterThan(0);
    }

    public void waitUntilNotPositive() throws InterruptedException {
        this.waitUntilLessThanOrEqual(0);
    }

    public void waitUntilNegative() throws InterruptedException {
        this.waitUntilLessThan(0);
    }

    public void waitUntilNotNegative() throws InterruptedException {
        this.waitUntilGreaterThanOrEqual(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitToSetValue(int v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotEqual_(v);
            return this.setChangedValue_(v);
        }
    }

    public int waitToSetZero() throws InterruptedException {
        return this.waitToSetValue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitToSwap(int expectedValue, int newValue) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEqual_(expectedValue);
            return this.setValue_(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEqual(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEqual_(v, timeout);
        }
    }

    private boolean waitUntilEqual_(int v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEqual_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value != v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value == v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotEqual(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilNotEqual_(v, timeout);
        }
    }

    private boolean waitUntilNotEqual_(int v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilNotEqual_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value == v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value != v;
    }

    public boolean waitUntilZero(long timeout) throws InterruptedException {
        return this.waitUntilEqual(0, timeout);
    }

    public boolean waitUntilNotZero(long timeout) throws InterruptedException {
        return this.waitUntilNotEqual(0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilGreaterThan(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilGreaterThan_(v, timeout);
        }
    }

    private boolean waitUntilGreaterThan_(int v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilGreaterThan_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value <= v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value > v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilGreaterThanOrEqual(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilGreaterThanOrEqual_(v, timeout);
        }
    }

    private boolean waitUntilGreaterThanOrEqual_(int v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilGreaterThanOrEqual_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value < v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value >= v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilLessThan(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilLessThan_(v, timeout);
        }
    }

    private boolean waitUntilLessThan_(int v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilLessThan_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value >= v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value < v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilLessThanOrEqual(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilLessThanOrEqual_(v, timeout);
        }
    }

    private boolean waitUntilLessThanOrEqual_(int v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilLessThanOrEqual_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value > v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value <= v;
    }

    public boolean waitUntilPositive(long timeout) throws InterruptedException {
        return this.waitUntilGreaterThan(0, timeout);
    }

    public boolean waitUntilNotPositive(long timeout) throws InterruptedException {
        return this.waitUntilLessThanOrEqual(0, timeout);
    }

    public boolean waitUntilNegative(long timeout) throws InterruptedException {
        return this.waitUntilLessThan(0, timeout);
    }

    public boolean waitUntilNotNegative(long timeout) throws InterruptedException {
        return this.waitUntilGreaterThanOrEqual(0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(int v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilNotEqual_(v, timeout);
            if (success) {
                this.setChangedValue_(v);
            }
            return success;
        }
    }

    public boolean waitToSetZero(long timeout) throws InterruptedException {
        return this.waitToSetValue(0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSwap(int expectedValue, int newValue, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEqual_(expectedValue, timeout);
            if (success) {
                this.setValue_(newValue);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public int compareTo(IntReference ref) {
        int otherValue;
        int thisValue = this.getValue();
        return thisValue < (otherValue = ref.getValue()) ? -1 : (thisValue == otherValue ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedInt clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return (SynchronizedInt)super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

