/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.reference.ModifiableBooleanReference;

public class SimpleBooleanReference
implements ModifiableBooleanReference,
Cloneable,
Serializable {
    protected volatile boolean value;
    private static final long serialVersionUID = 1L;

    public SimpleBooleanReference(boolean value) {
        this.value = value;
    }

    public SimpleBooleanReference() {
        this(false);
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean is(boolean v) {
        return this.value == v;
    }

    public boolean isNot(boolean v) {
        return this.value ^ v;
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public boolean setValue(boolean value) {
        boolean old = this.value;
        this.value = value;
        return old;
    }

    public boolean flip() {
        this.value = !this.value;
        return this.value;
    }

    public boolean setNot(boolean v) {
        return this.setValue(!v);
    }

    public boolean setTrue() {
        return this.setValue(true);
    }

    public boolean setFalse() {
        return this.setValue(false);
    }

    public SimpleBooleanReference clone() {
        try {
            return (SimpleBooleanReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

