/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemCollectionListValueModelAdapter<E>
extends ItemAspectListValueModelAdapter<E> {
    protected final String[] collectionNames;
    protected final CollectionChangeListener itemCollectionListener;

    public ItemCollectionListValueModelAdapter(ListValueModel<E> listHolder, String ... collectionNames) {
        super(listHolder);
        if (collectionNames == null) {
            throw new NullPointerException();
        }
        this.collectionNames = collectionNames;
        this.itemCollectionListener = this.buildItemCollectionListener();
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel<E> collectionHolder, String ... collectionNames) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder), collectionNames);
    }

    protected CollectionChangeListener buildItemCollectionListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(event);
            }

            public String toString() {
                return "item collection listener: " + Arrays.asList(ItemCollectionListValueModelAdapter.this.collectionNames);
            }
        };
    }

    @Override
    protected void engageItem_(Model item) {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            item.addCollectionChangeListener(collectionName, this.itemCollectionListener);
            ++n2;
        }
    }

    @Override
    protected void disengageItem_(Model item) {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            item.removeCollectionChangeListener(collectionName, this.itemCollectionListener);
            ++n2;
        }
    }
}

