/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class StaticMethodCommand
implements Command {
    private final Method method;
    private final Object[] arguments;

    public StaticMethodCommand(Method method, Object[] arguments) {
        if (method == null || arguments == null) {
            throw new NullPointerException();
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("method must be static: " + method);
        }
        if (!method.isAccessible()) {
            throw new IllegalArgumentException("method must be accessible: " + method);
        }
        this.method = method;
        this.arguments = arguments;
    }

    public void execute() {
        try {
            this.method.invoke(null, this.arguments);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.method);
    }
}

