/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class OutputColumnDefnPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private boolean modelChanged = true;
    protected PropertyHandle rsColumns;
    protected PropertyHandle columnHints;
    protected ColumnHandles columnHandles;
    protected Map rsColumnMap = new HashMap();
    protected Map columnHintMap = new HashMap();
    protected OutputColumnTableViewer viewer;
    private static Logger logger = Logger.getLogger(OutputColumnDefnPage.class.getName());
    protected static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();
    private static String NAME = "name";
    private static String TYPE = "dataType";
    private static String ALIAS = "alias";
    private static String DISPLAY_NAME = "displayName";
    private static String HELP_TEXT = "helpText";
    protected ColumnDefn newDefn = null;
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.outputColumns");
    private static String DEFAULT_COLUMN_NAME = "Column";
    protected String defaultDataTypeDisplayName = this.getTypeDisplayName("string");
    protected int defaultDataTypeIndex = this.getTypeIndex("string");
    protected String[] displayDataTypes = this.getDataTypeDisplayNames();

    public Control createContents(Composite parent) {
        this.rsColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("resultSetHints");
        this.columnHints = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        this.createCachedMap();
        this.columnHandles = new ColumnHandles(this.rsColumns, this.columnHints);
        this.viewer = new OutputColumnTableViewer(parent);
        this.createTableColumns();
        this.setTableContentProvider();
        this.setTableLabelProvider();
        this.addListeners();
        this.viewer.getViewer().setInput((Object)this.columnHandles);
        this.viewer.updateButtons();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    protected void addListeners() {
        this.viewer.getAddButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OutputColumnDefnPage.this.doNew();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.viewer.getEditButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OutputColumnDefnPage.this.doEdit();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    protected void doNew() {
        ColumnInputDialog inputDialog = new ColumnInputDialog(this.viewer.getControl().getShell(), Messages.getString((String)"ResultSetColumnPage.inputDialog.newColumn.title"), new ColumnDefn());
        if (inputDialog.open() == 0) {
            ColumnDefn newColumn = inputDialog.getColumnDefn();
            try {
                this.addNewDefn(newColumn);
                this.viewer.getViewer().refresh();
                this.updateMessage();
            }
            catch (SemanticException e) {
                this.getContainer().setMessage(Messages.getString((String)"OutputColumnPage.error.createNewColumn"), 3);
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.updateButtons();
    }

    protected void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index >= 0 && index < this.viewer.getViewer().getTable().getItemCount()) {
            ColumnDefn currentColumn = (ColumnDefn)this.viewer.getViewer().getTable().getItem(index).getData();
            String oldName = currentColumn.getColumnName();
            ColumnInputDialog inputDialog = new ColumnInputDialog(this.viewer.getControl().getShell(), Messages.getString((String)"ResultSetColumnPage.inputDialog.editColumn.title"), currentColumn);
            if (inputDialog.open() == 0) {
                this.updateColumnDefMap(oldName, inputDialog.getColumnDefn());
                this.viewer.getViewer().refresh();
                this.updateMessage();
            }
        } else {
            this.getContainer().setMessage(Messages.getString((String)"OutputColumnPage.error.invalidSelection"), 3);
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        this.viewer.getRemoveAllMenuItem().setEnabled(this.viewer.getViewer().getTable().getItemCount() > 0);
        if (this.viewer.getViewer().getTable().getSelectionCount() == 1) {
            this.viewer.getEditButton().setEnabled(true);
            this.viewer.getRemoveButton().setEnabled(true);
            this.viewer.getRemoveMenuItem().setEnabled(true);
            int index = this.viewer.getViewer().getTable().getSelectionIndex();
            this.viewer.getUpButton().setEnabled(index != 0);
            this.viewer.getDownButton().setEnabled(index != this.viewer.getViewer().getTable().getItemCount() - 1);
        } else {
            this.viewer.getEditButton().setEnabled(false);
            this.viewer.getUpButton().setEnabled(false);
            this.viewer.getRemoveButton().setEnabled(false);
            this.viewer.getDownButton().setEnabled(false);
            this.viewer.getRemoveMenuItem().setEnabled(false);
        }
    }

    protected void setTableContentProvider() {
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof ColumnHandles)) {
                    return new Object[0];
                }
                return ((ColumnHandles)inputElement).getColumnDefn().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    protected void setTableLabelProvider() {
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                ColumnDefn defn = null;
                if (!(element instanceof ColumnDefn)) {
                    return "";
                }
                defn = (ColumnDefn)element;
                switch (columnIndex) {
                    case 1: {
                        value = defn.getColumnName();
                        break;
                    }
                    case 2: {
                        if (defn == OutputColumnDefnPage.this.newDefn) break;
                        value = OutputColumnDefnPage.this.getTypeDisplayName(defn.getDataType());
                        break;
                    }
                    case 3: {
                        value = defn.getAlias();
                        break;
                    }
                    case 4: {
                        value = defn.getDisplayName();
                        break;
                    }
                    case 5: {
                        value = defn.getDisplayNameKey();
                    }
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    protected void createTableColumns() {
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.type"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.alias"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.displayName"));
        column.setWidth(100);
        TableColumn displayNameKeyColumn = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        displayNameKeyColumn.setText(Messages.getString((String)"dataset.editor.title.displayNameKey"));
        displayNameKeyColumn.setWidth(100);
    }

    protected ColumnHintHandle addNewDefn(ColumnDefn defn) throws SemanticException {
        ColumnHintHandle column = null;
        String name = defn.getColumnName();
        if (this.rsColumnMap != null) {
            if (this.rsColumnMap.get(name) != null) {
                name = this.getUniqueColumnName();
                defn.setColumnName(name);
            }
            if (this.rsColumns != null && this.columnHints != null) {
                this.rsColumns.addItem((IStructure)defn.getResultSetColumn());
                column = (ColumnHintHandle)this.columnHints.addItem((IStructure)defn.getColumnHint());
                this.rsColumnMap.put(name, defn.getResultSetColumn());
                this.columnHintMap.put(name, defn.getColumnHint());
            }
        }
        return column;
    }

    protected void updateColumnDefMap(String oldName, ColumnDefn column) {
        if (this.rsColumnMap != null && oldName != null && this.rsColumnMap.get(oldName) != null) {
            String newName = column.getColumnName();
            if (!oldName.equals(newName)) {
                this.rsColumnMap.remove(oldName);
                this.columnHintMap.remove(oldName);
            }
            this.rsColumnMap.put(newName, column.getResultSetColumn());
            this.columnHintMap.put(newName, column.getColumnHint());
        }
    }

    protected final int getTypeIndex(String dataTypeName) {
        int n = 0;
        while (n < dataTypes.length) {
            if (dataTypes[n].getName().equals(dataTypeName)) {
                return n;
            }
            ++n;
        }
        return this.defaultDataTypeIndex;
    }

    protected final String getTypeString(int index) {
        if (index > -1 && index < dataTypes.length) {
            return dataTypes[index].getName();
        }
        return null;
    }

    protected final String getTypeDisplayName(String typeName) {
        int n = 0;
        while (n < dataTypes.length) {
            if (dataTypes[n].getName().equals(typeName)) {
                return dataTypes[n].getDisplayName();
            }
            ++n;
        }
        return this.defaultDataTypeDisplayName;
    }

    private String[] getDataTypeDisplayNames() {
        String[] dataTypeDisplayNames = new String[dataTypes.length];
        int i = 0;
        while (i < dataTypes.length) {
            dataTypeDisplayNames[i] = dataTypes[i].getDisplayName();
            ++i;
        }
        return dataTypeDisplayNames;
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (this.modelChanged) {
            this.modelChanged = false;
            this.refreshColumns();
        }
    }

    private void refreshColumns() {
        try {
            this.refreshPositions();
            this.viewer.getViewer().refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final void refreshPositions() {
        if (this.rsColumns == null) {
            return;
        }
        int position = 1;
        Iterator iter = this.rsColumns.iterator();
        if (iter != null && this.rsColumns.isLocal()) {
            while (iter.hasNext()) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                column.setPosition(Integer.valueOf(position++));
            }
        }
    }

    protected String getUniqueColumnName() {
        String name = DEFAULT_COLUMN_NAME;
        int index = 0;
        while (!this.isUniqeColumnName(name)) {
            name = String.valueOf(DEFAULT_COLUMN_NAME) + "_" + ++index;
        }
        return name;
    }

    private boolean isUniqeColumnName(String name) {
        for (ColumnHintHandle hint : this.columnHints) {
            if (hint.getColumnName() == null || !hint.getColumnName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        this.disposeAll();
        return super.performCancel();
    }

    public boolean performOk() {
        if (!this.modelChanged) {
            this.disposeAll();
            return super.performOk();
        }
        if (this.isValid()) {
            this.refreshPositions();
            this.disposeAll();
            return super.performOk();
        }
        this.disposeAll();
        return false;
    }

    private boolean isValid() {
        boolean validate = true;
        if (this.columnHints == null) {
            this.columnHints = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        }
        Iterator iterator1 = this.columnHints.iterator();
        int i = 0;
        while (iterator1.hasNext() && validate) {
            ColumnHintHandle columnHint = (ColumnHintHandle)iterator1.next();
            String newColumnNameOrAlias = columnHint.getAlias();
            Iterator iterator2 = this.columnHints.iterator();
            if (newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0) {
                int n = 0;
                while (iterator2.hasNext()) {
                    ColumnHintHandle columnHint2 = (ColumnHintHandle)iterator2.next();
                    if (i != n && (columnHint2.getColumnName() != null && columnHint2.getColumnName().equals(newColumnNameOrAlias) || columnHint2.getAlias() != null && columnHint2.getAlias().equals(newColumnNameOrAlias))) {
                        validate = false;
                        this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.columnOrAliasNameAlreadyUsed", (Object[])new Object[]{newColumnNameOrAlias, n > i ? Integer.valueOf(i + 1) : Integer.valueOf(n + 1), n > i ? Integer.valueOf(n + 1) : Integer.valueOf(i + 1)}), 3);
                        break;
                    }
                    ++n;
                }
            }
            ++i;
        }
        return validate;
    }

    protected void updateMessage() {
        if (this.isValid()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        }
    }

    private void disposeAll() {
        this.rsColumnMap = null;
        this.columnHintMap = null;
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
    }

    public String getPageDescription() {
        return Messages.getString((String)"OutputColumnDefnPage.description");
    }

    public boolean canLeave() {
        if (!this.modelChanged) {
            return true;
        }
        if (this.isValid()) {
            this.refreshPositions();
            return super.canLeave();
        }
        return false;
    }

    private void refreshCachedMap() {
        this.columnHintMap.clear();
        this.rsColumnMap.clear();
        for (ColumnHintHandle handle : this.columnHints) {
            this.columnHintMap.put(handle.getColumnName(), handle.getStructure());
        }
        IStructure toDelete = null;
        if (this.rsColumns == null) {
            return;
        }
        for (ResultSetColumnHandle handle : this.rsColumns) {
            if (this.columnHintMap.get(handle.getColumnName()) == null) {
                toDelete = handle.getStructure();
                continue;
            }
            this.rsColumnMap.put(handle.getColumnName(), handle.getStructure());
        }
        if (toDelete != null) {
            try {
                this.rsColumns.removeItem(toDelete);
            }
            catch (PropertyValueException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void createCachedMap() {
        if (this.rsColumns == null) {
            return;
        }
        for (ResultSetColumnHandle handle : this.rsColumns) {
            this.rsColumnMap.put(handle.getColumnName(), handle.getStructure());
        }
        for (ResultSetColumnHandle handle : this.columnHints) {
            this.columnHintMap.put(handle.getColumnName(), handle.getStructure());
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"OutputColumnDefnPage.OutputColumns.Tooltip");
    }

    protected static class ColumnDefn {
        private ResultSetColumnHandle rsColumnHandle;
        private ColumnHintHandle columnHintHandle;
        private ResultSetColumn rsColumn;
        private ColumnHint columnHint;

        public ColumnDefn() {
            this.rsColumn = new ResultSetColumn();
            this.columnHint = new ColumnHint();
            this.setDataType("string");
        }

        public ColumnDefn(ResultSetColumnHandle rsHandle, ColumnHintHandle colHintHandle) {
            this.rsColumnHandle = rsHandle;
            this.columnHintHandle = colHintHandle;
        }

        public ResultSetColumn getResultSetColumn() {
            if (this.rsColumnHandle != null) {
                return (ResultSetColumn)this.rsColumnHandle.getStructure();
            }
            return this.rsColumn;
        }

        public ColumnHint getColumnHint() {
            if (this.columnHintHandle != null) {
                return (ColumnHint)this.columnHintHandle.getStructure();
            }
            return this.columnHint;
        }

        public ActionHandle setAction(Action action) throws SemanticException {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.setAction(action);
            }
            return null;
        }

        public ActionHandle getActionHandle() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getActionHandle();
            }
            return null;
        }

        public String getColumnName() {
            if (this.rsColumnHandle != null) {
                return this.rsColumnHandle.getColumnName();
            }
            if (this.rsColumn != null) {
                return this.rsColumn.getColumnName();
            }
            return null;
        }

        public void setColumnName(String columnName) {
            if (this.rsColumnHandle != null && this.columnHintHandle != null) {
                try {
                    this.rsColumnHandle.setColumnName(columnName);
                    this.columnHintHandle.setColumnName(columnName);
                }
                catch (SemanticException semanticException) {}
            } else if (this.rsColumn != null && this.columnHint != null) {
                this.rsColumn.setColumnName(columnName);
                this.columnHint.setProperty("columnName", (Object)columnName);
            }
        }

        public String getAnalysisType() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getAnalysis();
            }
            return (String)this.columnHint.getProperty(null, "analysis");
        }

        public void setAnalysis(String analysis) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setAnalysis(analysis);
            } else {
                this.columnHint.setProperty("analysis", (Object)analysis);
            }
        }

        public String getAnalysisColumn() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getAnalysisColumn();
            }
            return (String)this.columnHint.getProperty(null, "analysisColumn");
        }

        public void setAnalysisColumn(String analysisColumn) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setAnalysisColumn(analysisColumn);
            } else {
                this.columnHint.setProperty("analysisColumn", (Object)analysisColumn);
            }
        }

        public String getAlias() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getAlias();
            }
            return (String)this.columnHint.getProperty(null, "alias");
        }

        public void setAlias(String alias) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setAlias(alias);
            } else {
                this.columnHint.setProperty("alias", (Object)alias);
            }
        }

        public String getDataType() {
            if (this.rsColumnHandle != null) {
                return this.rsColumnHandle.getDataType();
            }
            return this.rsColumn.getDataType();
        }

        public void setDataType(String dataType) {
            try {
                if (this.rsColumnHandle != null) {
                    this.rsColumnHandle.setDataType(dataType);
                } else {
                    this.rsColumn.setDataType(dataType);
                }
            }
            catch (SemanticException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }

        public String getDisplayName() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getDisplayName();
            }
            return (String)this.columnHint.getProperty(null, "displayName");
        }

        public void setDisplayName(String displayName) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setDisplayName(displayName);
            } else if (displayName != null && displayName.trim().length() > 0) {
                this.columnHint.setProperty("displayName", (Object)displayName);
            }
        }

        public String getDisplayNameKey() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getDisplayNameKey();
            }
            return (String)this.columnHint.getProperty(null, "displayNameID");
        }

        public void setDisplayNameKey(String displayNameKey) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setDisplayNameKey(displayNameKey);
            } else {
                this.columnHint.setProperty("displayNameID", (Object)displayNameKey);
            }
        }

        public String getHelpText() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getHelpText();
            }
            return (String)this.columnHint.getProperty(null, "helpText");
        }

        public void setFormat(String format) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setFormat(format);
            } else {
                this.columnHint.setProperty("format", (Object)format);
            }
        }

        public String getFormat() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getFormat();
            }
            return (String)this.columnHint.getProperty(null, "format");
        }

        public void setDisplayLength(int length) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setDisplayLength(length);
            } else {
                this.columnHint.setProperty("displayLength", (Object)length);
            }
        }

        public int getDisplayLength() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getDisplayLength();
            }
            Object value = this.columnHint.getProperty(null, "displayLength");
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 0;
        }

        public void setHeading(String heading) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setHeading(heading);
            } else {
                this.columnHint.setProperty("heading", (Object)heading);
            }
        }

        public String getHeading() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getHeading();
            }
            return (String)this.columnHint.getProperty(null, "heading");
        }

        public void setHorizontalAlign(String horizontalAlign) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setHorizontalAlign(horizontalAlign);
            } else {
                this.columnHint.setProperty("horizontalAlign", (Object)horizontalAlign);
            }
        }

        public String getHorizontalAlign() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getHorizontalAlign();
            }
            return (String)this.columnHint.getProperty(null, "horizontalAlign");
        }

        public void setTextFormat(String textFormat) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setTextFormat(textFormat);
            } else {
                this.columnHint.setProperty("textFormat", (Object)textFormat);
            }
        }

        public String getTextFormat() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getTextFormat();
            }
            return (String)this.columnHint.getProperty(null, "textFormat");
        }

        public FormatValue getFormatValue() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getValueFormat();
            }
            return (FormatValue)this.columnHint.getProperty(null, "valueFormat");
        }

        public void setFormatValue(FormatValue format) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setValueFormat(format);
            } else {
                this.columnHint.setProperty("valueFormat", (Object)format);
            }
        }

        public void setDescription(String description) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setDescription(description);
            } else {
                this.columnHint.setProperty("description", (Object)description);
            }
        }

        public String getDescription() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getDescription();
            }
            return (String)this.columnHint.getProperty(null, "description");
        }

        public void setWordWrap(boolean wordWrap) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setWordWrap(wordWrap);
            } else {
                this.columnHint.setProperty("wordWrap", (Object)wordWrap);
            }
        }

        public boolean isWordWrap() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.wordWrap();
            }
            Object value = this.columnHint.getProperty(null, "wordWrap");
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return false;
        }

        public void setHelpText(String helpText) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setHelpText(helpText);
            } else {
                this.columnHint.setProperty("helpText", (Object)helpText);
            }
        }

        public Object getACLExpression() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getACLExpression();
            }
            return this.columnHint.getExpressionProperty("ACLExpression");
        }

        public void setACLExpression(Expression expr) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setExpressionProperty("ACLExpression", expr);
            } else {
                this.columnHint.setProperty("ACLExpression", (Object)expr);
            }
        }

        public boolean isIndexColumn() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.isIndexColumn();
            }
            if (this.columnHint.getProperty(null, "indexColumn") instanceof Boolean) {
                return (Boolean)this.columnHint.getProperty(null, "indexColumn");
            }
            return false;
        }

        public void setIndexColumn(boolean indexColumn) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setIndexColumn(indexColumn);
            } else {
                this.columnHint.setProperty("indexColumn", (Object)indexColumn);
            }
        }

        public boolean removeDuplicatedValues() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.isCompressed();
            }
            if (this.columnHint.getProperty(null, "compressed") instanceof Boolean) {
                return (Boolean)this.columnHint.getProperty(null, "compressed");
            }
            return false;
        }

        public void setRemoveDuplicatedValues(boolean shouldRemoveDuplicatedColumn) throws SemanticException {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setCompresssed(shouldRemoveDuplicatedColumn);
            } else {
                this.columnHint.setProperty("compressed", (Object)shouldRemoveDuplicatedColumn);
            }
        }

        public void setProperty(Object property, Object value) {
            if (property.equals(NAME)) {
                this.setColumnName((String)value);
            } else if (property.equals(TYPE)) {
                this.setDataType((String)value);
            } else if (property.equals(ALIAS)) {
                this.setAlias((String)value);
            } else if (property.equals(DISPLAY_NAME)) {
                this.setDisplayName((String)value);
            } else if (property.equals(HELP_TEXT)) {
                this.setHelpText((String)value);
            }
        }

        public Object getProperty(Object property) {
            if (property.equals(NAME)) {
                return this.getColumnName();
            }
            if (property.equals(TYPE)) {
                return this.getDataType();
            }
            if (property.equals(ALIAS)) {
                return this.getAlias();
            }
            if (property.equals(DISPLAY_NAME)) {
                return this.getDisplayName();
            }
            if (property.equals(HELP_TEXT)) {
                return this.getHelpText();
            }
            return null;
        }
    }

    private static class ColumnHandles {
        private PropertyHandle rsColumnHandle;
        private PropertyHandle chHandle;
        private List colList = null;

        ColumnHandles(PropertyHandle rsch, PropertyHandle chh) {
            this.rsColumnHandle = rsch;
            this.chHandle = chh;
        }

        public PropertyHandle getResultSetColumnHandle() {
            return this.rsColumnHandle;
        }

        public PropertyHandle getColumnHintHandle() {
            return this.chHandle;
        }

        public List getColumnDefn() {
            this.colList = new ArrayList();
            Iterator rsIter = this.rsColumnHandle.iterator();
            Iterator hintIter = this.chHandle.iterator();
            while (rsIter.hasNext()) {
                this.colList.add(new ColumnDefn((ResultSetColumnHandle)rsIter.next(), (ColumnHintHandle)hintIter.next()));
            }
            return this.colList;
        }

        public int size() {
            if (this.colList == null) {
                this.getColumnDefn();
            }
            return this.colList.size();
        }
    }

    private class ColumnInputDialog
    extends PropertyHandleInputDialog {
        private String title;
        private ColumnDefn columnDefn;
        private String columnName;
        private String alias;
        private String displayName;
        private String displayNameKey;
        private int dataType;
        private String EMPTY_STRING;

        public ColumnInputDialog(Shell shell, String title, ColumnDefn columnModel) {
            super(shell);
            this.EMPTY_STRING = "";
            this.title = title;
            this.columnDefn = columnModel;
            this.initColumnInfos();
        }

        protected void createCustomControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginTop = 5;
            composite.setLayout((Layout)layout);
            GridData layoutData = new GridData(1808);
            layoutData.widthHint = 320;
            layoutData.heightHint = 200;
            composite.setLayoutData((Object)layoutData);
            this.createDialogContents(composite);
        }

        private void createDialogContents(Composite composite) {
            GridData labelData = new GridData();
            labelData.horizontalSpan = 1;
            GridData textData = new GridData(768);
            textData.horizontalSpan = 2;
            Label columnNameLabel = new Label(composite, 0);
            columnNameLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.columnName"));
            columnNameLabel.setLayoutData((Object)labelData);
            final Text columnNameText = new Text(composite, 2048);
            columnNameText.setLayoutData((Object)textData);
            columnNameText.setText(this.columnName);
            columnNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.columnName = columnNameText.getText().trim();
                    ColumnInputDialog.this.validateSyntax();
                }
            });
            Label typeLabel = new Label(composite, 0);
            typeLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.dataType"));
            typeLabel.setLayoutData((Object)labelData);
            final Combo typeCombo = ControlProvider.createCombo(composite, 2056);
            typeCombo.setItems(OutputColumnDefnPage.this.displayDataTypes);
            typeCombo.setLayoutData((Object)textData);
            typeCombo.setText(typeCombo.getItem(this.dataType));
            typeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnInputDialog.this.dataType = typeCombo.getSelectionIndex();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Label aliasLabel = new Label(composite, 0);
            aliasLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.alias"));
            aliasLabel.setLayoutData((Object)labelData);
            final Text aliasText = new Text(composite, 2048);
            aliasText.setLayoutData((Object)textData);
            aliasText.setText(this.alias);
            aliasText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.alias = aliasText.getText().trim();
                    ColumnInputDialog.this.validateSyntax();
                }
            });
            Label displayNameLabel = new Label(composite, 0);
            displayNameLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.displayName"));
            displayNameLabel.setLayoutData((Object)labelData);
            final Text displayNameText = new Text(composite, 2048);
            displayNameText.setLayoutData((Object)textData);
            displayNameText.setText(this.displayName);
            displayNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.displayName = displayNameText.getText().trim();
                    ColumnInputDialog.this.validateSyntax();
                }
            });
            this.createDisplayNameKeyArea(composite);
        }

        private void createDisplayNameKeyArea(Composite parent) {
            Label displayNameKeyLabel = new Label(parent, 0);
            displayNameKeyLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.displayNameKey"));
            displayNameKeyLabel.setLayoutData((Object)new GridData());
            final Text tx = ControlProvider.createText(parent, this.displayNameKey);
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.displayNameKey = tx.getText().trim();
                    ColumnInputDialog.this.validateSyntax();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ResourceEditDialog dlg = new ResourceEditDialog(ColumnInputDialog.this.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
                    dlg.setResourceURLs(ColumnInputDialog.this.getResourceURLs());
                    if (dlg.open() == 0) {
                        tx.setText((String)dlg.getResult());
                    }
                }
            };
            Button bt = new Button(parent, 8);
            bt.setText("...");
            bt.addSelectionListener((SelectionListener)listener);
            if (this.getBaseName() == null) {
                bt.setEnabled(false);
            }
        }

        private String[] getBaseNames() {
            List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
            if (resources == null) {
                return null;
            }
            return resources.toArray(new String[0]);
        }

        private URL[] getResourceURLs() {
            String[] baseNames = this.getBaseNames();
            if (baseNames == null) {
                return null;
            }
            URL[] urls = new URL[baseNames.length];
            int i = 0;
            while (i < baseNames.length) {
                urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
                ++i;
            }
            return urls;
        }

        private String getBaseName() {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
        }

        protected boolean isResizable() {
            return true;
        }

        protected ColumnDefn getColumnDefn() {
            if (this.columnDefn == null) {
                this.columnDefn = new ColumnDefn();
            }
            this.columnDefn.setColumnName(this.columnName);
            this.columnDefn.setDataType(OutputColumnDefnPage.this.getTypeString(this.dataType));
            this.columnDefn.setAlias(this.alias);
            this.columnDefn.setDisplayName(this.displayName);
            this.columnDefn.setDisplayNameKey(this.displayNameKey);
            return this.columnDefn;
        }

        private void initColumnInfos() {
            if (this.columnDefn != null) {
                this.columnName = this.resolveNull(this.columnDefn.getColumnName());
                this.alias = this.resolveNull(this.columnDefn.getAlias());
                this.displayName = this.resolveNull(this.columnDefn.getDisplayName());
                this.displayNameKey = this.resolveNull(this.columnDefn.getDisplayNameKey());
                this.dataType = OutputColumnDefnPage.this.getTypeIndex(this.columnDefn.getDataType());
            } else {
                this.columnName = this.EMPTY_STRING;
                this.alias = this.EMPTY_STRING;
                this.displayName = this.EMPTY_STRING;
                this.displayNameKey = this.EMPTY_STRING;
                this.dataType = OutputColumnDefnPage.this.defaultDataTypeIndex;
            }
        }

        protected void rollback() {
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            if (this.columnName == null || this.columnName.trim().length() == 0) {
                return this.getMiscStatus(4, Messages.getString((String)"ResultSetColumnPage.inputDialog.warning.emptyColumnName"));
            }
            if (this.columnName.equals(this.alias)) {
                return this.getMiscStatus(4, Messages.getString((String)"ResultSetColumnPage.inputDialog.error.sameValue.columnNameAndAlias"));
            }
            if (this.isDuplicated(this.columnName)) {
                return this.getMiscStatus(4, Messages.getFormattedString((String)"ResultSetColumnPage.inputDialog.error.duplicatedColumnName", (Object[])new Object[]{this.columnName}));
            }
            if (this.isDuplicated(this.alias)) {
                return this.getMiscStatus(4, Messages.getFormattedString((String)"ResultSetColumnPage.inputDialog.error.duplicatedAlias", (Object[])new Object[]{this.alias}));
            }
            return this.getOKStatus();
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            return this.validateSyntax(structureOrHandle);
        }

        protected String getTitle() {
            return this.title;
        }

        private String resolveNull(String value) {
            return value == null ? this.EMPTY_STRING : value.trim();
        }

        private boolean isDuplicated(String newName) {
            if (newName == null || newName.trim().length() == 0) {
                return false;
            }
            Iterator iter = OutputColumnDefnPage.this.columnHintMap.keySet().iterator();
            while (iter.hasNext()) {
                ColumnHint column;
                Object value = OutputColumnDefnPage.this.columnHintMap.get(iter.next());
                if (!(value instanceof ColumnHint) || (column = (ColumnHint)value).equals((Object)this.columnDefn.getColumnHint()) || !newName.equals(column.getProperty(null, "alias")) && !newName.equals(column.getProperty(null, "columnName"))) continue;
                return true;
            }
            return false;
        }
    }

    protected class OutputColumnTableViewer {
        private TableViewer viewer;
        private Composite mainControl;
        private Button btnRemove;
        private Button btnUp;
        private Button btnDown;
        private Button btnAdd;
        private Button btnEdit;
        private MenuItem itmRemove;
        private MenuItem itmRemoveAll;
        private Menu menu;

        public OutputColumnTableViewer(Composite parent) {
            this.mainControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.mainControl.setLayout((Layout)layout);
            GridData data = null;
            this.viewer = new TableViewer(this.mainControl, 67584);
            data = new GridData(1808);
            this.viewer.getControl().setLayoutData((Object)data);
            this.viewer.getTable().setHeaderVisible(true);
            this.viewer.getTable().setLinesVisible(true);
            this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OutputColumnTableViewer.this.updateButtons();
                }
            });
            this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (OutputColumnTableViewer.this.viewer.getTable().getSelectionCount() == 1) {
                        OutputColumnDefnPage.this.doEdit();
                    }
                }
            });
            Composite btnComposite = new Composite(this.mainControl, 0);
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            btnComposite.setLayoutData((Object)data);
            GridLayout btnLayout = new GridLayout();
            layout.verticalSpacing = 20;
            btnComposite.setLayout((Layout)btnLayout);
            this.btnAdd = new Button(btnComposite, 0);
            this.btnAdd.setText(Messages.getString((String)"ResultSetColumnPage.button.add"));
            this.btnAdd.setEnabled(true);
            this.btnEdit = new Button(btnComposite, 0);
            this.btnEdit.setText(Messages.getString((String)"ResultSetColumnPage.button.edit"));
            this.btnRemove = new Button(btnComposite, 0);
            this.btnRemove.setText(Messages.getString((String)"ResultSetColumnPage.button.delete"));
            this.btnRemove.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputColumnTableViewer.this.removeSelectedItem();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btnUp = new Button(btnComposite, 0);
            this.btnUp.setText(Messages.getString((String)"ResultSetColumnPage.button.up"));
            this.btnUp.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputColumnTableViewer.this.doMoveUp();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btnDown = new Button(btnComposite, 0);
            this.btnDown.setText(Messages.getString((String)"ResultSetColumnPage.button.down"));
            this.btnDown.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputColumnTableViewer.this.doMoveDown();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            int width = this.getMaxWidth((Control)this.btnAdd, 55);
            width = this.getMaxWidth((Control)this.btnEdit, width);
            width = this.getMaxWidth((Control)this.btnRemove, width);
            width = this.getMaxWidth((Control)this.btnUp, width);
            width = this.getMaxWidth((Control)this.btnDown, width);
            GridData btnData = new GridData(2);
            btnData.widthHint = width;
            this.btnAdd.setLayoutData((Object)btnData);
            this.btnEdit.setLayoutData((Object)btnData);
            this.btnRemove.setLayoutData((Object)btnData);
            this.btnUp.setLayoutData((Object)btnData);
            this.btnDown.setLayoutData((Object)btnData);
            this.menu = new Menu((Control)this.viewer.getTable());
            this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    OutputColumnTableViewer.this.viewer.cancelEditing();
                }
            });
            this.itmRemove = new MenuItem(this.menu, 0);
            this.itmRemove.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Remove"));
            this.itmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OutputColumnTableViewer.this.removeSelectedItem();
                }
            });
            this.itmRemoveAll = new MenuItem(this.menu, 0);
            this.itmRemoveAll.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.RemoveAll"));
            this.itmRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OutputColumnTableViewer.this.doRemoveAll();
                }
            });
            this.viewer.getTable().setMenu(this.menu);
            this.viewer.getTable().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    OutputColumnTableViewer.this.viewer.getTable();
                }

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 127) {
                        OutputColumnTableViewer.this.removeSelectedItem();
                    }
                }
            });
        }

        private int getMaxWidth(Control control, int size) {
            int width = control.computeSize((int)-1, (int)-1).x;
            return width > size ? width : size;
        }

        private void updateButtons() {
            this.itmRemoveAll.setEnabled(this.viewer.getTable().getItemCount() > 0);
            if (this.viewer.getTable().getSelectionCount() == 1) {
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.itmRemove.setEnabled(true);
                int index = this.viewer.getTable().getSelectionIndex();
                this.btnUp.setEnabled(index != 0);
                this.btnDown.setEnabled(index != this.viewer.getTable().getItemCount() - 1);
            } else {
                this.btnEdit.setEnabled(false);
                this.btnUp.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnDown.setEnabled(false);
                this.itmRemove.setEnabled(false);
            }
        }

        public TableViewer getViewer() {
            return this.viewer;
        }

        public Composite getControl() {
            return this.mainControl;
        }

        public Button getAddButton() {
            return this.btnAdd;
        }

        public Button getEditButton() {
            return this.btnEdit;
        }

        public Button getDownButton() {
            return this.btnDown;
        }

        public Button getUpButton() {
            return this.btnUp;
        }

        public Button getRemoveButton() {
            return this.btnRemove;
        }

        public MenuItem getRemoveMenuItem() {
            return this.itmRemove;
        }

        public MenuItem getRemoveAllMenuItem() {
            return this.itmRemoveAll;
        }

        private final void removeSelectedItem() {
            int index = this.viewer.getTable().getSelectionIndex();
            if (index > -1 && index < OutputColumnDefnPage.this.columnHandles.size()) {
                try {
                    if (OutputColumnDefnPage.this.rsColumns != null) {
                        OutputColumnDefnPage.this.rsColumns.removeItem(index);
                    }
                    OutputColumnDefnPage.this.columnHints.removeItem(index);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                this.viewer.refresh();
                this.viewer.getTable().select(index);
                OutputColumnDefnPage.this.refreshCachedMap();
            }
            this.updateButtons();
        }

        private void doMoveUp() {
            int index = this.viewer.getTable().getSelectionIndex();
            if (index - 1 >= 0 && index < OutputColumnDefnPage.this.columnHandles.size()) {
                this.viewer.cancelEditing();
                try {
                    if (OutputColumnDefnPage.this.rsColumns != null) {
                        OutputColumnDefnPage.this.rsColumns.moveItem(index, index - 1);
                    }
                    if (OutputColumnDefnPage.this.columnHints != null) {
                        OutputColumnDefnPage.this.columnHints.moveItem(index, index - 1);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                this.viewer.refresh();
                this.viewer.getTable().select(index - 1);
                this.updateButtons();
            }
        }

        private void doMoveDown() {
            int index = this.viewer.getTable().getSelectionIndex();
            if (index > -1 && index < OutputColumnDefnPage.this.columnHandles.size() - 1) {
                this.viewer.cancelEditing();
                try {
                    if (OutputColumnDefnPage.this.rsColumns != null) {
                        OutputColumnDefnPage.this.rsColumns.moveItem(index, index + 1);
                    }
                    if (OutputColumnDefnPage.this.columnHints != null) {
                        OutputColumnDefnPage.this.columnHints.moveItem(index, index + 1);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                this.viewer.refresh();
                this.viewer.getTable().select(index + 1);
                this.updateButtons();
            }
        }

        private void doRemoveAll() {
            try {
                if (OutputColumnDefnPage.this.rsColumns != null) {
                    OutputColumnDefnPage.this.rsColumns.clearValue();
                }
                OutputColumnDefnPage.this.columnHints.clearValue();
                this.viewer.refresh();
            }
            catch (Exception e1) {
                logger.log(Level.FINE, e1.getMessage(), e1);
            }
            OutputColumnDefnPage.this.columnHintMap.clear();
            OutputColumnDefnPage.this.rsColumnMap.clear();
            this.updateButtons();
        }
    }
}

