/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property;

import java.util.Hashtable;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.IntObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.BPSimDataType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.BpsimPackage;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ControlParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.CostParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ElementParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.FloatingParameterType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.NormalDistributionType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.Parameter;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ParameterValue;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.PoissonDistributionType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ResourceParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.Scenario;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.TimeParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.UniformDistributionType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util.JbpmModelUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class SimulationDetailComposite
extends DefaultDetailComposite {
    public SimulationDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public SimulationDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void cleanBindings() {
        super.cleanBindings();
    }

    protected boolean isModelObjectEnabled(String className, String featureName) {
        return true;
    }

    public void createBindings(EObject be) {
        this.setTitle(String.valueOf(ModelUtil.getLabel((Object)be.eClass())) + Messages.SimulationDetailComposite_Title);
        if (be instanceof BPMNDiagram) {
            BPSimDataType pad = JbpmModelUtil.getBPSimData(be);
            Scenario scenario = (Scenario)pad.getScenario().get(0);
            scenario.getScenarioParameters().getBaseTimeUnit();
            this.bindAttribute(this.getAttributesParent(), scenario, BpsimPackage.eINSTANCE.getScenario_Name(), Messages.SimulationDetailComposite_Scenario);
            this.bindAttribute(this.getAttributesParent(), scenario.getScenarioParameters(), BpsimPackage.eINSTANCE.getScenarioParameters_BaseTimeUnit(), Messages.SimulationDetailComposite_Base_Time_Units);
            this.bindAttribute(this.getAttributesParent(), scenario.getScenarioParameters(), BpsimPackage.eINSTANCE.getScenarioParameters_BaseCurrencyUnit(), Messages.SimulationDetailComposite_Base_Currency_Units);
        } else if (be instanceof Task) {
            ElementParameters elementParams = JbpmModelUtil.getElementParameters((BaseElement)be);
            this.bindProcessingTime(elementParams);
            if (be instanceof UserTask) {
                ResourceParameters resourceParams = elementParams.getResourceParameters();
                Parameter param = resourceParams.getQuantity();
                FloatingParameterType quantity = (FloatingParameterType)param.getParameterValue().get(0);
                this.bindAttribute(this.getAttributesParent(), quantity, BpsimPackage.eINSTANCE.getFloatingParameterType_Value(), Messages.SimulationDetailComposite_Quantity);
                param = resourceParams.getAvailability();
                FloatingParameterType workingHours = (FloatingParameterType)param.getParameterValue().get(0);
                this.bindAttribute(this.getAttributesParent(), workingHours, BpsimPackage.eINSTANCE.getFloatingParameterType_Value(), Messages.SimulationDetailComposite_Availability);
            }
        } else if (be instanceof CatchEvent) {
            ElementParameters elementParams = JbpmModelUtil.getElementParameters((BaseElement)be);
            TimeParameters timeParams = elementParams.getTimeParameters();
            Parameter param = timeParams.getWaitTime();
            FloatingParameterType waitTime = (FloatingParameterType)param.getParameterValue().get(0);
            this.bindAttribute(this.getAttributesParent(), waitTime, BpsimPackage.eINSTANCE.getFloatingParameterType_Value(), Messages.SimulationDetailComposite_Wait_Time);
        } else if (be instanceof ThrowEvent) {
            ElementParameters elementParams = JbpmModelUtil.getElementParameters((BaseElement)be);
            this.bindProcessingTime(elementParams);
        } else if (be instanceof SequenceFlow) {
            ElementParameters elementParams = JbpmModelUtil.getElementParameters((BaseElement)be);
            ControlParameters controlParams = elementParams.getControlParameters();
            Parameter param = controlParams.getProbability();
            FloatingParameterType probability = (FloatingParameterType)param.getParameterValue().get(0);
            this.bindAttribute(this.getAttributesParent(), probability, BpsimPackage.eINSTANCE.getFloatingParameterType_Value(), Messages.SimulationDetailComposite_Probability);
        }
    }

    private void bindProcessingTime(ElementParameters elementParams) {
        Object editor;
        Parameter param;
        final TimeParameters timeParams = elementParams.getTimeParameters();
        CostParameters costParams = elementParams.getCostParameters();
        if (costParams != null) {
            param = costParams.getUnitCost();
            final FloatingParameterType decimalValue = (FloatingParameterType)param.getParameterValue().get(0);
            editor = new IntObjectEditor((AbstractDetailComposite)this, decimalValue, (EStructuralFeature)BpsimPackage.eINSTANCE.getFloatingParameterType_Value()){

                protected boolean setValue(final Object result) {
                    TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            decimalValue.setValue((Double)result);
                        }
                    });
                    return true;
                }
            };
            editor.createControl(this.getAttributesParent(), Messages.SimulationDetailComposite_Cost_Per_Time_Unit);
        }
        editor = new ComboObjectEditor((AbstractDetailComposite)this, timeParams, (EStructuralFeature)BpsimPackage.eINSTANCE.getTimeParameters_ProcessingTime()){
            Hashtable<String, Object> choices;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.choices = null;
            }

            protected boolean canEdit() {
                return false;
            }

            protected boolean canEditInline() {
                return false;
            }

            protected boolean canCreateNew() {
                return false;
            }

            protected boolean canSetNull() {
                return false;
            }

            protected boolean setValue(Object result) {
                final JbpmModelUtil.DistributionType dt = (JbpmModelUtil.DistributionType)((Object)result);
                TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        timeParams.setProcessingTime(JbpmModelUtil.createParameter(dt, 0.0, 0.0));
                    }
                });
                SimulationDetailComposite.this.setBusinessObject(SimulationDetailComposite.this.getBusinessObject());
                return true;
            }

            protected Hashtable<String, Object> getChoiceOfValues(EObject object, EStructuralFeature feature) {
                if (this.choices == null) {
                    this.choices = new Hashtable();
                    JbpmModelUtil.DistributionType[] distributionTypeArray = JbpmModelUtil.DistributionType.values();
                    int n = distributionTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JbpmModelUtil.DistributionType dt = distributionTypeArray[n2];
                        this.choices.put(dt.name(), (Object)dt);
                        ++n2;
                    }
                }
                return this.choices;
            }

            protected void fillCombo() {
                super.fillCombo();
                Parameter param = timeParams.getProcessingTime();
                ParameterValue value = (ParameterValue)param.getParameterValue().get(0);
                StructuredSelection currentSelection = null;
                if (value instanceof UniformDistributionType) {
                    currentSelection = new StructuredSelection((Object)JbpmModelUtil.DistributionType.Uniform.name());
                } else if (value instanceof NormalDistributionType) {
                    currentSelection = new StructuredSelection((Object)JbpmModelUtil.DistributionType.Normal.name());
                } else if (value instanceof PoissonDistributionType) {
                    currentSelection = new StructuredSelection((Object)JbpmModelUtil.DistributionType.Poisson.name());
                }
                if (currentSelection != null) {
                    this.comboViewer.setSelection((ISelection)currentSelection);
                }
            }
        };
        editor.createControl(this.getAttributesParent(), Messages.SimulationDetailComposite_Distribution_Type);
        param = timeParams.getProcessingTime();
        ParameterValue value = (ParameterValue)param.getParameterValue().get(0);
        if (value instanceof UniformDistributionType) {
            this.bindAttribute(this.getAttributesParent(), value, BpsimPackage.eINSTANCE.getUniformDistributionType_Min(), Messages.SimulationDetailComposite_Processing_Time_Min);
            this.bindAttribute(this.getAttributesParent(), value, BpsimPackage.eINSTANCE.getUniformDistributionType_Max(), Messages.SimulationDetailComposite_Processing_Time_Max);
        } else if (value instanceof NormalDistributionType) {
            this.bindAttribute(this.getAttributesParent(), value, BpsimPackage.eINSTANCE.getNormalDistributionType_Mean(), Messages.SimulationDetailComposite_Processing_Time_Mean);
            this.bindAttribute(this.getAttributesParent(), value, BpsimPackage.eINSTANCE.getNormalDistributionType_StandardDeviation(), Messages.SimulationDetailComposite_Standard_Deviation);
        } else if (value instanceof PoissonDistributionType) {
            this.bindAttribute(this.getAttributesParent(), value, BpsimPackage.eINSTANCE.getPoissonDistributionType_Mean(), Messages.SimulationDetailComposite_Processing_Time_Mean);
        }
    }
}

