/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;

public class AbstractTrace
implements DebugOptionsListener {
    public static final String STRING_CONFIG = "/config";
    public static final String STRING_INFO = "/info";
    public static final String STRING_WARNING = "/warning";
    public static final String STRING_SEVERE = "/severe";
    public static final String STRING_FINER = "/finer";
    public static final String STRING_FINEST = "/finest";
    public static final String STRING_RESOURCES = "/resources";
    public static final String STRING_EXTENSION_POINT = "/extension_point";
    public static final String STRING_LISTENERS = "/listeners";
    private Plugin plugin;
    private Map<String, Boolean> optionsMap = new HashMap<String, Boolean>();

    protected AbstractTrace(Plugin plugin) {
        this.plugin = plugin;
        this.createDefaultDebugSettings();
    }

    protected void createDefaultDebugSettings() {
        this.getOptionsMap().put(STRING_CONFIG, new Boolean(false));
        this.getOptionsMap().put(STRING_INFO, new Boolean(false));
        this.getOptionsMap().put(STRING_WARNING, new Boolean(false));
        this.getOptionsMap().put(STRING_SEVERE, new Boolean(false));
        this.getOptionsMap().put(STRING_FINER, new Boolean(false));
        this.getOptionsMap().put(STRING_FINEST, new Boolean(false));
        this.getOptionsMap().put(STRING_RESOURCES, new Boolean(false));
        this.getOptionsMap().put(STRING_EXTENSION_POINT, new Boolean(false));
        this.getOptionsMap().put(STRING_LISTENERS, new Boolean(false));
    }

    public void optionsChanged(DebugOptions options) {
        String pid = this.plugin.getBundle().getSymbolicName();
        this.getOptionsMap().put(STRING_CONFIG, options.getBooleanOption(String.valueOf(pid) + STRING_CONFIG, false));
        this.getOptionsMap().put(STRING_INFO, options.getBooleanOption(String.valueOf(pid) + STRING_INFO, false));
        this.getOptionsMap().put(STRING_WARNING, options.getBooleanOption(String.valueOf(pid) + STRING_WARNING, false));
        this.getOptionsMap().put(STRING_SEVERE, options.getBooleanOption(String.valueOf(pid) + STRING_SEVERE, false));
        this.getOptionsMap().put(STRING_FINER, options.getBooleanOption(String.valueOf(pid) + STRING_FINER, false));
        this.getOptionsMap().put(STRING_FINEST, options.getBooleanOption(String.valueOf(pid) + STRING_FINEST, false));
        this.getOptionsMap().put(STRING_RESOURCES, options.getBooleanOption(String.valueOf(pid) + STRING_RESOURCES, false));
        this.getOptionsMap().put(STRING_EXTENSION_POINT, options.getBooleanOption(String.valueOf(pid) + STRING_EXTENSION_POINT, false));
        this.getOptionsMap().put(STRING_LISTENERS, options.getBooleanOption(String.valueOf(pid) + STRING_LISTENERS, false));
    }

    protected static void traceInternal(AbstractTrace at, String level, String s) {
        AbstractTrace.traceInternal(at, level, s, null);
    }

    protected static void traceInternal(AbstractTrace at, String level, String s, Throwable t) {
        if (level == null || at == null) {
            return;
        }
        Boolean val = at.optionsMap.get(level);
        if (val == null || !val.booleanValue()) {
            return;
        }
        if (s == null) {
            return;
        }
        if (STRING_SEVERE.equals(level)) {
            at.plugin.getLog().log(StatusFactory.errorStatus(at.plugin.getBundle().getSymbolicName(), s, t));
        }
        if (at.plugin.isDebugging()) {
            StringBuilder sb = new StringBuilder(at.plugin.getBundle().getSymbolicName());
            sb.append(" ").append(level).append(" ").append(AbstractTrace.formatDate()).append(" ").append(s);
            System.out.println(sb.toString());
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    protected static String formatDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
        return sdf.format(new Date());
    }

    protected Map<String, Boolean> getOptionsMap() {
        return this.optionsMap;
    }
}

