/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class WaitValidator
extends CActivityValidator {
    protected INode untilExpr;
    protected INode forExpr;

    @Override
    protected void start() {
        super.start();
        this.forExpr = this.mNode.getNode(ND_FOR);
        this.untilExpr = this.mNode.getNode(ND_UNTIL);
    }

    @ARule(date="9/22/2006", desc="Do a basic sanity check on the wait activity.", author="michal.chmielewski@oracle.com", errors="BPELC_EMPTY_EXPIRATION_SETTING,BPELC_MULTIPLE_EXPIRATION_SETTING")
    public void rule_BasicSanityCheck_5() {
        IProblem problem;
        if (this.forExpr == null && this.untilExpr == null) {
            problem = this.createError();
            problem.setAttribute("context.name", AT_FOR);
            problem.fill("BPELC_EMPTY_EXPIRATION_SETTING", this.toString(this.mNode.nodeName()));
        }
        if (this.forExpr != null && this.untilExpr != null) {
            problem = this.createError();
            problem.setAttribute("context.name", AT_FOR);
            problem.fill("BPELC_MULTIPLE_EXPIRATION_SETTING", this.toString(this.mNode.nodeName()));
        }
    }
}

