/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class OnAlarmValidator
extends CValidator {
    protected INode untilExpr;
    protected INode forExpr;
    protected boolean fIsEventHandler = false;
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_PICK, ND_EVENT_HANDLERS);

    @Override
    protected void start() {
        super.start();
        this.forExpr = this.mNode.getNode(ND_FOR);
        this.untilExpr = this.mNode.getNode(ND_UNTIL);
        this.fIsEventHandler = this.fParentNode.nodeName().equals(ND_EVENT_HANDLERS);
    }

    @Override
    public void checkChildren() {
        super.checkChildren();
        if (this.fIsEventHandler) {
            this.checkChild(ND_REPEAT_EVERY, 0, 1);
            this.checkChild(ND_SCOPE, 1, 1);
        } else {
            this.checkChild(Filters.ACTIVITIES, 1, 1);
        }
    }

    @ARule(desc="Basic sanity check of wait activity", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC_EMPTY_EXPIRATION_SETTING,BPELC_MULTIPLE_EXPIRATION_SETTING")
    public void rule_BasicSanityCheck_5() {
        IProblem problem;
        if (this.forExpr == null && this.untilExpr == null) {
            problem = this.createError();
            problem.fill("BPELC_EMPTY_EXPIRATION_SETTING", this.toString(this.mNode.nodeName()));
        }
        if (this.forExpr != null && this.untilExpr != null) {
            problem = this.createError();
            problem.fill("BPELC_MULTIPLE_EXPIRATION_SETTING", this.toString(this.mNode.nodeName()));
        }
    }
}

