/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class CorrelationSetValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_CORRELATION_SETS);
    protected String ncName;
    protected String fProperties;

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_NAME);
        this.fProperties = this.mNode.getAttribute(AT_PROPERTIES);
    }

    @ARule(sa=0, desc="Check the NCName of the correlationSet", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        this.checkNCName(this.mNode, this.ncName, AT_NAME);
    }

    @ARule(sa=44, desc="Check to see if the correlationSet is already specified", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_DUPLICATE_NAME")
    public void rule_CheckDuplicateCorrelationSet_2() {
        if (this.ncName == null) {
            return;
        }
        String key = "set." + this.ncName;
        if (this.containsValueKey(this.fParentNode, key)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_DUPLICATE_NAME", this.toString(this.mNode.parentNode().nodeName()), this.toString(this.mNode.nodeName()), this.ncName);
            return;
        }
        this.setValue(this.fParentNode, key, Boolean.TRUE);
    }

    @ARule(desc="Check if property attribute is set", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE")
    public void rule_CheckPropertiesAttribute_10() {
        if (CorrelationSetValidator.isEmptyOrWhitespace(this.fProperties)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_PROPERTIES, 0);
        }
    }

    @ARule(sa=45, desc="Properties used in a <correlationSet> MUST be defined using  XML Schema simple types.", author="michal.chmielewski@oracle.com", date="03/01/2007", errors="BPELC__UNRESOLVED_ATTRIBUTE,BPELC_XSD__NOT_SIMPLE_TYPE")
    public void rule_CheckProperties_15() {
        String[] qnList;
        if (CorrelationSetValidator.isEmpty(this.fProperties)) {
            return;
        }
        String[] stringArray = qnList = this.fProperties.split("\\s");
        int n = qnList.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem;
            String qName = stringArray[n2];
            INode property = this.mModelQuery.lookup(this.mNode, 14, qName);
            if (this.isUndefined(property)) {
                problem = this.createError();
                problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_PROPERTIES, 0, qName);
            } else {
                INode typeDef;
                String atType = property.getAttribute(AT_TYPE);
                if (!(CorrelationSetValidator.isEmpty(atType) || this.isUndefined(typeDef = this.mModelQuery.lookup(this.mNode, 9, atType)) || this.mModelQuery.check(1, typeDef, null))) {
                    problem = this.createError();
                    problem.fill("BPELC_XSD__NOT_SIMPLE_TYPE", this.toString(this.mNode.nodeName()), atType, "text.property", qName);
                }
            }
            ++n2;
        }
    }
}

