/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.bpel.fnmeta.model.FMPackage;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.validator.factory.BPELValidatorAdapterFactory;
import org.eclipse.bpel.validator.factory.FunctionMetaValidatorAdapterFactory;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.IFactory;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.bpel.validator";
    static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Logger logger = Logger.getLogger(PLUGIN_ID);
        LogHandler handler = new LogHandler();
        logger.addHandler(handler);
        this.initializeAndTime();
    }

    void initialize() {
        String name;
        Object obj;
        IConfigurationElement ce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension e;
        int n3;
        int n4;
        IExtension[] iExtensionArray;
        String epName = "factories";
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, epName);
        if (ep != null) {
            iExtensionArray = ep.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                e = iExtensionArray[n3];
                iConfigurationElementArray = e.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    ce = iConfigurationElementArray[n];
                    obj = null;
                    try {
                        obj = ce.createExecutableExtension("class");
                    }
                    catch (CoreException e1) {
                        Activator.log((Exception)((Object)e1));
                    }
                    if (obj != null && obj instanceof IFactory) {
                        RuleFactory.INSTANCE.registerFactory((IFactory)obj);
                    }
                    ++n;
                }
                ++n3;
            }
        } else {
            name = "org.eclipse.bpel.validator." + epName;
            Activator.log(null, 4, "Extension point " + name + " is not avaialble.");
        }
        epName = "modelQuery";
        ep = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, epName);
        if (ep != null) {
            iExtensionArray = ep.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                e = iExtensionArray[n3];
                iConfigurationElementArray = e.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    ce = iConfigurationElementArray[n];
                    obj = null;
                    try {
                        obj = ce.createExecutableExtension("class");
                    }
                    catch (CoreException e1) {
                        Activator.log((Exception)((Object)e1));
                    }
                    if (obj != null && obj instanceof IModelQuery) {
                        ModelQueryImpl.register((IModelQuery)obj);
                    }
                    ++n;
                }
                ++n3;
            }
        } else {
            name = "org.eclipse.bpel.validator." + epName;
            Activator.log(null, 4, "Extension point " + name + " is not avaialble.");
        }
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)FMPackage.eINSTANCE, (AdapterFactory)FunctionMetaValidatorAdapterFactory.INSTANCE);
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)BPELPackage.eINSTANCE, (AdapterFactory)BPELValidatorAdapterFactory.INSTANCE);
    }

    IStatus initializeAndTime() {
        long start = System.currentTimeMillis();
        this.initialize();
        long end = System.currentTimeMillis();
        Status status = new Status(1, PLUGIN_ID, 0, "Validator Startup " + (end - start) + "ms", null);
        return status;
    }

    void initializeAsync() {
        Job job = new Job("Registering Validator factories ..."){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Activator.this.initializeAndTime();
                monitor.done();
                this.done(Job.ASYNC_FINISH);
                return status;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        AdapterRegistry.INSTANCE.unregisterAdapterFactory((EPackage)FMPackage.eINSTANCE, (AdapterFactory)FunctionMetaValidatorAdapterFactory.INSTANCE);
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)BPELPackage.eINSTANCE, (AdapterFactory)BPELValidatorAdapterFactory.INSTANCE);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Exception e, int severity, String message) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)((Object)e)).getStatus();
        } else {
            String m = message;
            if (m == null) {
                e.getMessage();
            }
            status = new Status(severity, PLUGIN_ID, 0, m == null ? "<no message>" : m, (Throwable)e);
        }
        plugin.getLog().log(status);
    }

    public static void log(Exception e) {
        Activator.log(e, 4, null);
    }

    class LogHandler
    extends Handler {
        LogHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getThreadID());
            sb.append(":");
            sb.append(record.getLoggerName());
            sb.append(":");
            sb.append(record.getMessage());
            Throwable t = record.getThrown();
            int severity = 1;
            if (record.getLevel() == Level.SEVERE) {
                severity = 4;
            } else if (record.getLevel() == Level.WARNING) {
                severity = 2;
            }
            Status status = new Status(severity, Activator.PLUGIN_ID, 0, sb.toString(), t);
            plugin.getLog().log((IStatus)status);
        }
    }
}

