/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.web;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.ITaggedVirtualResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.core.CommonCorePlugin;

public class WebUtils {
    private static final IContainer[] EMPTY_ARRAY = new IContainer[0];
    public static final String DD_FOLDER_TAG = "defaultRootSource";

    public static IPath[] getWebInfPaths(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.getRootFolder() != null) {
            IContainer[] cs;
            ArrayList<IPath> ps = new ArrayList<IPath>();
            IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders(project, true);
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder f;
                IContainer c = iContainerArray[n2];
                if (c.exists() && (f = c.getFolder((IPath)new Path("/WEB-INF"))).exists()) {
                    ps.add(f.getFullPath());
                }
                ++n2;
            }
            return ps.toArray(new IPath[ps.size()]);
        }
        return new IPath[0];
    }

    public static IPath[] getWebContentPaths(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.getRootFolder() != null) {
            IContainer[] cs;
            ArrayList<IPath> ps = new ArrayList<IPath>();
            IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders(project, true);
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                if (c.exists()) {
                    ps.add(c.getFullPath());
                }
                ++n2;
            }
            return ps.toArray(new IPath[ps.size()]);
        }
        return new IPath[0];
    }

    public static IPath getFirstWebContentPath(IProject project) {
        IContainer[] cs;
        IPath modulePath = null;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null || vc.getRootFolder() == null) {
            return null;
        }
        IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders(project, true);
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            if (c.exists()) {
                return c.getFullPath();
            }
            ++n2;
        }
        return modulePath;
    }

    public static IContainer getWebRootFolder(IResource resource) {
        IProject project = resource.getProject();
        if (project != null) {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            if (vc == null || vc.getRootFolder() == null) {
                return null;
            }
            IContainer[] cs = WebUtils.getWebRootFolders(project, false);
            IPath fullPath = resource.getFullPath();
            IContainer[] iContainerArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                if (c.exists() && c.getFullPath().isPrefixOf(fullPath)) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IContainer[] getWebRootFolders(IProject project, boolean ignoreDerived) {
        IVirtualComponent component;
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
        IProjectFacet DYNAMIC_WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        if (facetedProject != null && facetedProject.getProjectFacetVersion(DYNAMIC_WEB_FACET) != null && (component = ComponentCore.createComponent((IProject)project)) != null) {
            IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            IPath defaultPath = WebUtils.getDefaultDeploymentDescriptorFolder(webRootVirtFolder);
            IContainer defaultResource = null;
            IContainer[] folders = webRootVirtFolder.getUnderlyingFolders();
            if (folders.length > 1) {
                ArrayList<IContainer> containers = new ArrayList<IContainer>();
                IContainer[] iContainerArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    if (!ignoreDerived || !container.isDerived(512)) {
                        String path = "/" + container.getProjectRelativePath().toString();
                        if (defaultPath != null && path.equals(defaultPath.toString())) {
                            defaultResource = container;
                        } else {
                            containers.add(container);
                        }
                    }
                    ++n2;
                }
                if (defaultResource != null) {
                    containers.add(0, defaultResource);
                }
                return containers.toArray(new IContainer[containers.size()]);
            }
            return folders;
        }
        return EMPTY_ARRAY;
    }

    public static IPath getDefaultDeploymentDescriptorFolder(IVirtualFolder folder) {
        IPath returnValue = null;
        if (folder instanceof ITaggedVirtualResource) {
            returnValue = ((ITaggedVirtualResource)folder).getFirstTaggedResource(DD_FOLDER_TAG);
        }
        return returnValue;
    }
}

