/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.reporting;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.reporting.Submit;
import org.jboss.tools.common.util.FileUtils;
import org.osgi.framework.Bundle;

public class ProblemBuffer {
    ProblemBuffer() {
    }

    public int getSize() {
        String s = this.getContent();
        if (s.length() == 0) {
            return 0;
        }
        int i = 0;
        int c = 0;
        while (i < s.length()) {
            if ((i = s.indexOf("!ENTRY", i)) < 0) break;
            ++c;
            ++i;
        }
        return c;
    }

    public String getContent() {
        File f = this.getLogFile();
        return !f.isFile() ? "" : FileUtils.readFile(f);
    }

    public String getEclipseLogContent() {
        File f = Platform.getLogFileLocation().toFile();
        return f.isFile() ? FileUtils.readFile(f) : "";
    }

    public void clean() {
        File f = this.getLogFile();
        if (f.exists()) {
            f.delete();
        }
    }

    public void report(String text, String userEMail, String other, boolean cleanBuffer) {
        StringBuffer sb = new StringBuffer();
        if (userEMail != null && userEMail.trim().length() > 0) {
            sb.append("Customer e-mail=" + userEMail + "\n");
        }
        if (other != null && other.length() > 0) {
            sb.append("Other=" + other + "\n");
        }
        if (text != null) {
            sb.append(text);
        }
        String reportText = sb.toString();
        Submit.getInstance().submit(reportText, cleanBuffer);
    }

    private File getLogFile() {
        Bundle b = Platform.getBundle((String)"org.jboss.tools.common");
        String stateLocation = Platform.getStateLocation((Bundle)b).toString().replace('\\', '/');
        String logLocation = String.valueOf(stateLocation) + "/.log";
        return new File(logLocation);
    }
}

