/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.log;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.log.ILoggingAdapter;

public class PluginLogger
implements ILoggingAdapter {
    private Plugin plugin;

    public PluginLogger(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void error(String message) {
        this.log(4, message);
    }

    @Override
    public void debug(String message) {
        this.log(1, message);
    }

    private void log(int severity, String message) {
        if (!this.isTracingEnabled()) {
            return;
        }
        if (this.plugin != null) {
            Status status = new Status(severity, this.plugin.getBundle().getSymbolicName(), message);
            this.plugin.getLog().log((IStatus)status);
        }
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    protected boolean isTracingEnabled() {
        return true;
    }
}

