/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java.impl;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IAnnotationType;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.impl.EmptyValues;
import org.jboss.tools.common.java.impl.IValues;
import org.jboss.tools.common.java.impl.JavaAnnotation;
import org.jboss.tools.common.java.impl.ValueResolver;

public class AnnotationDeclaration
implements IAnnotationDeclaration {
    public static final String VALUE = "value";
    protected IJavaAnnotation annotation;
    protected IValues values = EmptyValues.instance;
    protected IValues constants = EmptyValues.instance;
    protected IValues defaults = EmptyValues.instance;

    public void setDeclaration(IJavaAnnotation annotation) {
        this.annotation = annotation;
        IMemberValuePair[] pairs = this.getMemberValuePairs();
        if (pairs.length > 0) {
            ValueResolver r = new ValueResolver((IJavaElement)this.getJavaAnnotation());
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                String name = pair.getMemberName();
                Object value = r.resolvePair(pair);
                if (value != null) {
                    this.values = this.values.put(name, value);
                }
                if (r.getConstant() != null) {
                    this.constants = this.constants.put(name, r.getConstant());
                }
                ++n2;
            }
            r.dispose();
        }
        try {
            this.loadDefaults();
        }
        catch (CoreException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
    }

    private void loadDefaults() throws CoreException {
        IMethod[] ms;
        IType type = this.getType();
        if (type == null) {
            return;
        }
        IMethod[] iMethodArray = ms = type.getMethods();
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            String n3 = m.getElementName();
            IMemberValuePair p = m.getDefaultValue();
            if (p != null) {
                n3 = p.getMemberName();
                Object o = p.getValue();
                if (o == null) {
                    String expression = null;
                    String s = m.getSource();
                    if (s != null) {
                        int i = s.indexOf("default");
                        int j = s.lastIndexOf(59);
                        if (i > 0 && j > i) {
                            expression = s.substring(i + 7, j).trim();
                        }
                    }
                    if (expression != null) {
                        ValueResolver r = new ValueResolver((IJavaElement)m);
                        o = r.resolveExpression(expression);
                        r.dispose();
                    }
                }
                if (o != null) {
                    this.defaults = this.defaults.put(n3, o);
                }
            }
            ++n2;
        }
    }

    public IJavaAnnotation getDeclaration() {
        return this.annotation;
    }

    @Override
    public IResource getResource() {
        return this.annotation.getResource();
    }

    @Override
    public IMemberValuePair[] getMemberValuePairs() {
        return this.annotation.getMemberValuePairs();
    }

    @Override
    public Object getMemberValue(String name) {
        if (name == null) {
            name = VALUE;
        }
        return this.values.get(name);
    }

    public Object getMemberConstantValue(String name) {
        if (name == null) {
            name = VALUE;
        }
        return this.constants.get(name);
    }

    public Object getMemberValue(String name, boolean resolve) {
        Object result = null;
        if (resolve) {
            result = this.getMemberConstantValue(name);
        }
        if (result == null) {
            result = this.getMemberValue(name);
        }
        return result;
    }

    public Object getMemberDefaultValue(String name) {
        if (name == null) {
            name = VALUE;
        }
        return this.defaults.get(name);
    }

    @Override
    public IMember getParentMember() {
        return this.annotation.getParentMember();
    }

    @Override
    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    @Override
    public IType getType() {
        return this.annotation.getType();
    }

    @Override
    public int getLength() {
        return this.annotation.getLength();
    }

    @Override
    public int getStartPosition() {
        return this.annotation.getStartPosition();
    }

    @Override
    public IAnnotationType getAnnotation() {
        return null;
    }

    @Override
    public IAnnotation getJavaAnnotation() {
        if (this.annotation instanceof JavaAnnotation) {
            return ((JavaAnnotation)this.annotation).getAnnotation();
        }
        return null;
    }

    @Override
    public IMember getSourceMember() {
        return this.getParentMember();
    }

    @Override
    public IJavaElement getSourceElement() {
        return this.annotation.getParentElement();
    }
}

