/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaProject;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.nature.HibernateNature;
import org.jboss.tools.hibernate.jpt.core.internal.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;

public class HibernateJpaProject
extends AbstractJpaProject {
    private Boolean cachedNamingStrategyEnable;
    private final JobCommand revalidateCommand = new RevalidateProjectCommand();

    public HibernateJpaProject(JpaProject.Config config) {
        super(config);
    }

    public ConsoleConfiguration getDefaultConsoleConfiguration() {
        HibernateNature nature = HibernateNature.getHibernateNature((IJavaProject)this.getJavaProject());
        if (nature != null) {
            return nature.getDefaultConsoleConfiguration();
        }
        return null;
    }

    public NamingStrategy getNamingStrategy() {
        ConsoleConfiguration cc = this.getDefaultConsoleConfiguration();
        if (cc != null && cc.getConfiguration() != null) {
            Configuration config = cc.getConfiguration();
            return config.getNamingStrategy();
        }
        return null;
    }

    public BasicHibernateProperties getBasicHibernateProperties() {
        PersistenceUnit persistenceUnit;
        PersistenceXml persistenceXml;
        Persistence persistence;
        if (this.getContextRoot() != null && (persistence = (persistenceXml = this.getContextRoot().getPersistenceXml()).getRoot()).getPersistenceUnitsSize() > 0 && (persistenceUnit = persistence.getPersistenceUnit(0)) instanceof HibernatePersistenceUnit) {
            return ((HibernatePersistenceUnit)persistenceUnit).getHibernatePersistenceUnitProperties();
        }
        return null;
    }

    public String getDefaultSchema() {
        String schema = null;
        ConsoleConfiguration cc = this.getDefaultConsoleConfiguration();
        if (cc != null) {
            Properties properties;
            Configuration configuration;
            if (cc.hasConfiguration() && (configuration = cc.getConfiguration()).getProperties().containsKey("hibernate.default_schema")) {
                schema = configuration.getProperty("hibernate.default_schema");
            }
            if ((properties = cc.getPreferences().getProperties()) != null && properties.containsKey("hibernate.default_schema")) {
                schema = properties.getProperty("hibernate.default_schema");
            }
        }
        if (schema == null) {
            BasicHibernateProperties prop = this.getBasicHibernateProperties();
            if (this.getUserOverrideDefaultSchema() != null) {
                schema = this.getUserOverrideDefaultSchema();
            } else if (prop != null && prop.getSchemaDefault() != null) {
                schema = prop.getSchemaDefault();
            }
        }
        return schema != null ? schema : super.getDefaultSchema();
    }

    public String getDefaultCatalog() {
        String catalog = null;
        BasicHibernateProperties prop = this.getBasicHibernateProperties();
        ConsoleConfiguration cc = this.getDefaultConsoleConfiguration();
        if (cc != null) {
            Properties properties;
            Configuration configuration;
            if (cc.hasConfiguration() && (configuration = cc.getConfiguration()).getProperties().containsKey("hibernate.default_catalog")) {
                catalog = configuration.getProperty("hibernate.default_catalog");
            }
            if ((properties = cc.getPreferences().getProperties()) != null && properties.containsKey("hibernate.default_catalog")) {
                catalog = properties.getProperty("hibernate.default_catalog");
            }
        }
        if (catalog == null) {
            if (this.getUserOverrideDefaultCatalog() != null) {
                catalog = this.getUserOverrideDefaultCatalog();
            } else if (prop != null && prop.getCatalogDefault() != null) {
                catalog = prop.getCatalogDefault();
            }
        }
        return catalog != null ? catalog : super.getDefaultCatalog();
    }

    public String getDefaultConsoleConfigurationName() {
        HibernateNature nature = HibernateNature.getHibernateNature((IJavaProject)this.getJavaProject());
        if (nature != null) {
            return nature.getDefaultConsoleConfigurationName();
        }
        return null;
    }

    public boolean isNamingStrategyEnabled() {
        if (this.cachedNamingStrategyEnable == null) {
            ProjectScope scope = new ProjectScope(this.getProject());
            IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
            this.cachedNamingStrategyEnable = node != null ? Boolean.valueOf(node.getBoolean("namingStrategy.enabled", true)) : Boolean.valueOf(true);
        }
        return this.cachedNamingStrategyEnable;
    }

    protected Iterable<JpaFile> getJavaPackageInfoSourceJpaFiles() {
        return this.getJpaFiles(JavaResourceCompilationUnit.PACKAGE_INFO_CONTENT_TYPE);
    }

    protected Iterable<JavaResourcePackageInfoCompilationUnit> getInternalJavaResourcePackageInfoCompilationUnits() {
        return new TransformationIterable(this.getJavaPackageInfoSourceJpaFiles(), (Transformer)new Transformer<JpaFile, JavaResourcePackageInfoCompilationUnit>(){

            public JavaResourcePackageInfoCompilationUnit transform(JpaFile jpaFile) {
                return (JavaResourcePackageInfoCompilationUnit)jpaFile.getResourceModel();
            }
        });
    }

    protected Iterable<JavaResourcePackage> getInternalSourceJavaResourcePackages() {
        return new TransformationIterable(this.getInternalJavaResourcePackageInfoCompilationUnits(), (Transformer)new Transformer<JavaResourcePackageInfoCompilationUnit, JavaResourcePackage>(){

            public JavaResourcePackage transform(JavaResourcePackageInfoCompilationUnit compilationUnit) {
                return compilationUnit.getPackage();
            }
        });
    }

    protected Iterable<JavaResourcePackage> getInternalAnnotatedSourceJavaResourcePacakges() {
        return new FilteringIterable(this.getInternalSourceJavaResourcePackages(), PredicateTools.true_());
    }

    protected Iterable<JavaResourcePackage> getInternalMappedSourceJavaResourcePackages() {
        return this.getInternalAnnotatedSourceJavaResourcePacakges();
    }

    public Iterable<String> getMappedJavaSourcePackagesNames() {
        return new TransformationIterable(this.getInternalMappedSourceJavaResourcePackages(), (Transformer)new Transformer<JavaResourcePackage, String>(){

            public String transform(JavaResourcePackage jrpPackage) {
                return jrpPackage == null ? null : jrpPackage.getName();
            }
        });
    }

    protected boolean synchronizeJpaFiles(IFile file, int deltaKind) {
        boolean result = super.synchronizeJpaFiles(file, deltaKind);
        ConsoleConfiguration cc = this.getDefaultConsoleConfiguration();
        if (cc != null) {
            ConsoleConfigurationPreferences preferences = cc.getPreferences();
            if (file.getLocation().toFile().equals(preferences.getPropertyFile())) {
                switch (deltaKind) {
                    case 1: 
                    case 2: 
                    case 4: {
                        this.stateChanged();
                        this.revalidate();
                    }
                }
            }
        }
        return result;
    }

    protected void revalidate() {
        this.getManager().execute(this.revalidateCommand, Messages.HibernateJpaProject_Update_Hibernate_properties, (JpaProject)this);
    }

    protected void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConsoleConfiguration(messages);
    }

    protected void validateConsoleConfiguration(List<IMessage> messages) {
        if (KnownConfigurations.getInstance().find(this.getDefaultConsoleConfigurationName()) == null) {
            IMessage message = HibernateJpaValidationMessage.buildMessage(1, "CC_NOT_EXISTS", new String[]{this.getDefaultConsoleConfigurationName()}, this.getResource());
            messages.add(message);
        }
    }

    public JavaResourcePackage getJavaResourcePackage(String packageName) {
        for (JavaResourcePackage jrp : this.getJavaResourcePackages()) {
            if (jrp.getName() == null || !jrp.getName().equals(packageName)) continue;
            return jrp;
        }
        return null;
    }

    class RevalidateProjectCommand
    implements JobCommand {
        RevalidateProjectCommand() {
        }

        public IStatus execute(IProgressMonitor monitor) {
            try {
                ValidationFramework.getDefault().validate(new IProject[]{HibernateJpaProject.this.getProject()}, false, true, (IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return new Status(4, "org.jboss.tools.hibernate.jpt.core", e.getMessage(), (Throwable)e);
            }
        }
    }
}

