/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWFactory;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWGenericUserMapping;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWOption;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWGenericUserMappingImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogUserMapping
extends LUWGenericUserMappingImpl
implements ICatalogObject {
    protected static final String REMOTE_AUTHID = "REMOTE_AUTHID";
    protected static final String REMOTE_PASSWORD = "REMOTE_PASSWORD";
    protected static final String ASTERISKS = "******";
    private boolean optionsLoaded = false;
    private boolean remoteUserLoaded = false;
    private boolean remotePasswordLoaded = false;

    public void refresh() {
        this.remoteUserLoaded = false;
        this.remotePasswordLoaded = false;
        if (this.optionsLoaded) {
            this.optionsLoaded = false;
            this.getOptions().clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getServer().getWrapper().getLUWDatabase();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getOptions();
        } else if (id == 11) {
            this.getRemoteUser();
        } else if (id == 12) {
            this.getRemotePassword();
        }
        return super.eIsSet(eFeature);
    }

    public EList getOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getOptions();
        }
        if (!this.optionsLoaded) {
            this.loadOptions();
        }
        return super.getOptions();
    }

    public String getRemoteUser() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getRemoteUser();
        }
        if (!this.remoteUserLoaded) {
            this.loadRemoteUser();
        }
        return super.getRemoteUser();
    }

    public String getRemotePassword() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getRemotePassword();
        }
        if (!this.remotePasswordLoaded) {
            this.loadRemotePassword();
        }
        return super.getRemotePassword();
    }

    private synchronized void loadRemoteUser() {
        if (this.remoteUserLoaded) {
            return;
        }
        EList options = this.getOptions();
        for (LUWOption option : options) {
            String name = option.getName();
            if (!name.equals(REMOTE_AUTHID)) continue;
            this.setRemoteUser(option.getValue());
            break;
        }
    }

    private synchronized void loadRemotePassword() {
        if (this.remotePasswordLoaded) {
            return;
        }
        EList options = this.getOptions();
        for (LUWOption option : options) {
            String name = option.getName();
            if (!name.equals(REMOTE_PASSWORD)) continue;
            this.setRemotePassword(option.getValue());
            break;
        }
    }

    public void setRemoteUser(String value) {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            super.setRemoteUser(value);
        } else {
            super.setRemoteUser(value);
            this.remoteUserLoaded = true;
        }
    }

    public void setRemotePassword(String value) {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            super.setRemotePassword(value);
        } else {
            super.setRemotePassword(value);
            this.remotePasswordLoaded = true;
        }
    }

    private synchronized void loadOptions() {
        if (this.optionsLoaded) {
            return;
        }
        this.optionsLoaded = true;
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList options = super.getOptions();
            options.clear();
            LUWCatalogUserMapping.loadOptions(this.getConnection(), this, options);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    public static void loadOptions(Connection connection, LUWGenericUserMapping userMapping, EList options) throws SQLException {
        String query = "SELECT OPTION, SETTING FROM SYSCAT.USEROPTIONS WHERE AUTHID='" + userMapping.getLocalAuthId() + "' AND SERVERNAME='" + userMapping.getServer().getName() + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String name = r.getString("OPTION");
                String value = r.getString("SETTING");
                LUWOption option = LUWFactory.eINSTANCE.createLUWOption();
                option.setName(name);
                if (name.equals(REMOTE_PASSWORD)) {
                    option.setValue(ASTERISKS);
                } else {
                    option.setValue(value);
                }
                options.add((Object)option);
            }
        }
        catch (Exception exception) {}
        r.close();
        s.close();
    }
}

