/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogStructuredUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModule;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWRowDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWCursorDataTypeImpl;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Schema;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogCursorDataType
extends LUWCursorDataTypeImpl
implements ICatalogObject {
    private boolean rowTypeLoaded = false;

    public void refresh() {
        this.rowTypeLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
    }

    public LUWRowDataType getRowType() {
        if (!this.rowTypeLoaded) {
            this.loadRowType();
        }
        return this.rowType;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getRowType();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadRowType() {
        if (this.rowTypeLoaded) {
            return;
        }
        this.rowTypeLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            String query = "SELECT  BSCHEMA,BMODULENAME,BNAME FROM SYSCAT.DATATYPEDEP  WHERE TYPESCHEMA = '" + LUWUtil.getIdentifier(this.getSchema().getName()) + "'" + " AND TYPENAME = '" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND BTYPE ='R'" + " AND TYPEMODULENAME IS NULL";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String name;
                String moduleName;
                String schemaName = r.getString("BSCHEMA").trim();
                LUWRowDataType rowType = LUWCatalogCursorDataType.getLUWRowDataType(this, schemaName, moduleName = r.getString("BMODULENAME"), name = r.getString("BNAME").trim());
                if (rowType == null) continue;
                this.setRowType(rowType);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private static LUWRowDataType getLUWRowDataType(UserDefinedType udt, String schemaName, String moduleName, String userDefinedTypeName) {
        block3: {
            Schema schema;
            block2: {
                schema = LUWCatalogStructuredUserDefinedType.getSchema(udt, schemaName);
                if (moduleName == null || "".equals(moduleName)) break block2;
                LUWModule module = LUWCatalogCursorDataType.getLUWModue((DB2Schema)schema, moduleName);
                if (module == null) break block3;
                for (Object obj : module.getModuleObjects()) {
                    if (!(obj instanceof LUWRowDataType) || !((SQLObject)obj).getName().equals(userDefinedTypeName)) continue;
                    return (LUWRowDataType)obj;
                }
                break block3;
            }
            for (UserDefinedType userDefinedType : schema.getUserDefinedTypes()) {
                if (!(userDefinedType instanceof LUWRowDataType) || !userDefinedType.getName().equals(userDefinedTypeName)) continue;
                return (LUWRowDataType)userDefinedType;
            }
        }
        return null;
    }

    private static LUWModule getLUWModue(DB2Schema schema, String moduleName) {
        for (LUWModule module : schema.getModules()) {
            if (!moduleName.trim().equals(module.getName())) continue;
            return module;
        }
        return null;
    }
}

