/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.util.BeanPresentationUtil;
import org.jboss.tools.cdi.internal.core.event.CDIProjectChangeEvent;
import org.jboss.tools.cdi.internal.core.event.ICDIProjectChangeListener;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;

public class OpenCDINamedBeanDialog
extends FilteredItemsSelectionDialog {
    private static final String FILE_NAME = "OpenCDINamedBeanHistory.xml";
    private static final String ROOT_NODE = "historyRootNode";
    private static final String INFO_NODE = "infoNode";
    private static final String PROJECT_NAME = "ProjectName";
    private static final String BEAN_NAME = "BeanName";
    private static final String DELETED = "Deleted";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final ICDIProjectChangeListener cdiProjectListener = new ICDIProjectChangeListener(){

        public void projectChanged(CDIProjectChangeEvent event) {
            OpenCDINamedBeanDialog.validateHistory(event.getProject());
        }
    };

    public OpenCDINamedBeanDialog(Shell shell) {
        this(shell, false);
    }

    public OpenCDINamedBeanDialog(Shell shell, boolean disableHistory) {
        super(shell);
        if (!disableHistory) {
            this.setSelectionHistory(new CDINamedBeanSelectionHistory());
        }
        this.setListLabelProvider(new CDINamedBeanLabelProvider());
        this.setDetailsLabelProvider(new CDINamedBeanLabelProvider());
    }

    public boolean close() {
        CDICorePlugin.removeCDIProjectListener((ICDIProjectChangeListener)cdiProjectListener);
        return super.close();
    }

    public int open() {
        if (this.getSelectionHistory() != null) {
            XMLMemento memento = OpenCDINamedBeanDialog.loadMemento();
            if (memento != null) {
                this.getSelectionHistory().load((IMemento)memento);
                OpenCDINamedBeanDialog.updateHistory(memento);
                OpenCDINamedBeanDialog.saveMemento(memento);
            }
            CDICorePlugin.addCDIProjectListener((ICDIProjectChangeListener)cdiProjectListener);
        }
        return super.open();
    }

    private static void updateHistory(XMLMemento memento) {
        XMLMemento historyMemento = (XMLMemento)memento.getChild(ROOT_NODE);
        if (historyMemento == null) {
            return;
        }
        IMemento[] mementoElements = historyMemento.getChildren(INFO_NODE);
        int i = 0;
        while (i < mementoElements.length) {
            IMemento mem = mementoElements[i];
            String projectName = mem.getString(PROJECT_NAME);
            if (projectName == null) {
                mem.putString(DELETED, YES);
            } else {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ICDIProject cdiProject = CDICorePlugin.getCDIProject((IProject)project, (boolean)true);
                if (cdiProject == null) {
                    mem.putString(DELETED, YES);
                } else {
                    OpenCDINamedBeanDialog.validateHistory(cdiProject, memento);
                }
            }
            ++i;
        }
    }

    public void startSearch() {
        this.applyFilter();
    }

    public void okPressed() {
        super.okPressed();
    }

    public void stopSearchAndShowResults() {
        this.refresh();
        List list = this.getSelectedItems().toList();
        Collections.sort(list, this.getItemsComparator());
        this.setResult(list);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new CDINamedBeanFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.subTask(CDIUIMessages.OPEN_CDI_NAMED_BEAN_DIALOG_WAIT);
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException interruptedException) {}
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        progressMonitor.beginTask(CDIUIMessages.OPEN_CDI_NAMED_BEAN_DIALOG_LOADING, projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            progressMonitor.subTask(project.getName());
            ICDIProject cdiProject = CDICorePlugin.getCDIProject((IProject)project, (boolean)true);
            if (cdiProject != null) {
                for (IBean bean : cdiProject.getNamedBeans(false)) {
                    if (cdiProject != bean.getDeclaringProject()) continue;
                    contentProvider.add((Object)new CDINamedBeanWrapper(bean.getName(), project.getName(), bean), itemsFilter);
                }
            }
            progressMonitor.worked(1);
            ++n2;
        }
        progressMonitor.done();
    }

    private static XMLMemento loadMemento() {
        XMLMemento memento = null;
        IPath stateLocation = CDIUIPlugin.getDefault().getStateLocation().append(FILE_NAME);
        File file = new File(stateLocation.toOSString());
        if (file.exists()) {
            InputStreamReader reader = null;
            try {
                try {
                    reader = new FileReader(file);
                    memento = XMLMemento.createReadRoot((Reader)reader);
                }
                catch (IOException ex) {
                    CDICorePlugin.getDefault().logError((Throwable)ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex2) {
                        CDICorePlugin.getDefault().logError((Throwable)ex2);
                    }
                }
                catch (WorkbenchException ex) {
                    CDICorePlugin.getDefault().logError((Throwable)ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex3) {
                        CDICorePlugin.getDefault().logError((Throwable)ex3);
                    }
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    CDICorePlugin.getDefault().logError((Throwable)ex);
                }
            }
        }
        return memento;
    }

    private static void saveMemento(XMLMemento xmlMemento) {
        IPath stateLocation = CDIUIPlugin.getDefault().getStateLocation().append(FILE_NAME);
        File file = new File(stateLocation.toOSString());
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                xmlMemento.save((Writer)writer);
            }
            catch (IOException ex) {
                CDICorePlugin.getDefault().logError((Throwable)ex);
                try {
                    writer.close();
                }
                catch (IOException ex2) {
                    CDICorePlugin.getDefault().logError((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                CDICorePlugin.getDefault().logError((Throwable)ex);
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings(CDIUIMessages.OPEN_CDI_NAMED_BEAN_DIALOG_NAME);
    }

    public String getElementName(Object item) {
        if (item instanceof CDINamedBeanWrapper) {
            CDINamedBeanWrapper beanWrapper = (CDINamedBeanWrapper)item;
            return beanWrapper.getBeanName();
        }
        return null;
    }

    protected Comparator<CDINamedBeanWrapper> getItemsComparator() {
        return new CDINamedBeanComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(this.getSelectedItems().size() >= 0 ? 0 : 4, "org.jboss.tools.cdi.ui", null);
    }

    public static void validateHistory(ICDIProject cdiProject) {
        XMLMemento memento = OpenCDINamedBeanDialog.loadMemento();
        if (memento != null) {
            OpenCDINamedBeanDialog.validateHistory(cdiProject, memento);
            OpenCDINamedBeanDialog.saveMemento(memento);
        }
    }

    public static void validateHistory(ICDIProject cdiProject, XMLMemento memento) {
        String cdiProjectName = cdiProject.getNature().getProject().getName();
        XMLMemento historyMemento = (XMLMemento)memento.getChild(ROOT_NODE);
        if (historyMemento == null) {
            return;
        }
        IMemento[] mementoElements = historyMemento.getChildren(INFO_NODE);
        int i = 0;
        while (i < mementoElements.length) {
            IMemento mem = mementoElements[i];
            String projectName = mem.getString(PROJECT_NAME);
            if (projectName == null) {
                mem.putString(DELETED, YES);
            } else if (projectName.equals(cdiProjectName)) {
                if (!cdiProject.getNature().getProject().exists()) {
                    mem.putString(DELETED, YES);
                } else {
                    String beanName = mem.getString(BEAN_NAME);
                    if (beanName == null) {
                        mem.putString(DELETED, YES);
                    } else {
                        IBean bean;
                        Collection beans = cdiProject.getBeans(beanName, true);
                        IBean iBean = bean = beans == null || beans.isEmpty() ? null : (IBean)beans.iterator().next();
                        if (bean == null) {
                            mem.putString(DELETED, YES);
                        } else {
                            mem.putString(DELETED, NO);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static class CDIBeanStyler
    extends StyledString.Styler {
        private final Color foreground;

        public CDIBeanStyler(Color foreground) {
            this.foreground = foreground;
        }

        public void applyStyles(TextStyle textStyle) {
            if (this.foreground != null) {
                textStyle.foreground = this.foreground;
            }
        }
    }

    public class CDINamedBeanComparator
    implements Comparator<CDINamedBeanWrapper> {
        @Override
        public int compare(CDINamedBeanWrapper left, CDINamedBeanWrapper right) {
            return left.getBeanName().compareTo(right.getBeanName());
        }
    }

    public class CDINamedBeanFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public CDINamedBeanFilter() {
            super((FilteredItemsSelectionDialog)OpenCDINamedBeanDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            if (item instanceof CDINamedBeanWrapper) {
                IBean bean;
                CDINamedBeanWrapper beanWrapper = (CDINamedBeanWrapper)item;
                String projectName = beanWrapper.getProjectName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ICDIProject cdiProject = CDICorePlugin.getCDIProject((IProject)project, (boolean)true);
                if (cdiProject == null) {
                    return false;
                }
                String beanName = beanWrapper.getBeanName();
                Collection beans = cdiProject.getBeans(beanName, true);
                IBean iBean = bean = beans == null || beans.isEmpty() ? null : (IBean)beans.iterator().next();
                return bean != null;
            }
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof CDINamedBeanWrapper) {
                int lastIndex;
                String pattern;
                CDINamedBeanWrapper beanWrapper = (CDINamedBeanWrapper)item;
                boolean result = this.patternMatcher.matches(beanWrapper.getBeanName());
                if (!result && (pattern = this.patternMatcher.getPattern()).indexOf(".") < 0 && (lastIndex = beanWrapper.getBeanName().lastIndexOf(".")) >= 0 && lastIndex + 1 < beanWrapper.getBeanName().length()) {
                    return this.patternMatcher.matches(beanWrapper.getBeanName().substring(lastIndex + 1));
                }
                return result;
            }
            return false;
        }
    }

    public class CDINamedBeanLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ILabelProvider {
        final Color gray = new Color(null, 128, 128, 128);
        StyledString.Styler nameStyle;
        final StyledString.Styler beanPathStyle = new CDIBeanStyler(this.gray);

        private StyledString.Styler getNameStyle() {
            if (this.nameStyle == null) {
                Color black = OpenCDINamedBeanDialog.this.getShell().getDisplay().getSystemColor(28);
                this.nameStyle = new CDIBeanStyler(black);
            }
            return this.nameStyle;
        }

        public Image getImage(Object element) {
            if (element instanceof CDINamedBeanWrapper) {
                return CDIImages.getImageByElement((ICDIElement)((CDINamedBeanWrapper)element).getBean());
            }
            return null;
        }

        public String getTextString(Object element) {
            StringBuffer text = new StringBuffer();
            if (element instanceof CDINamedBeanWrapper) {
                CDINamedBeanWrapper beanWrapper = (CDINamedBeanWrapper)element;
                text.append(beanWrapper.getBeanName());
                IBean b = beanWrapper.getBean();
                if (b != null) {
                    String beanLocation = BeanPresentationUtil.getBeanLocation((IBean)b, (boolean)true);
                    text.append(beanLocation);
                }
            }
            return text.toString();
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof CDINamedBeanWrapper) {
                CDINamedBeanWrapper beanWrapper = (CDINamedBeanWrapper)element;
                styledString.append(beanWrapper.getBeanName(), this.getNameStyle());
                IBean b = beanWrapper.getBean();
                if (b != null) {
                    String beanLocation = BeanPresentationUtil.getBeanLocation((IBean)b, (boolean)true);
                    styledString.append(beanLocation, this.beanPathStyle);
                }
            }
            return styledString;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class CDINamedBeanSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        protected Object restoreItemFromMemento(IMemento memento) {
            XMLMemento mem = (XMLMemento)memento;
            String projectName = mem.getString(OpenCDINamedBeanDialog.PROJECT_NAME);
            if (projectName == null) {
                return null;
            }
            String beanName = mem.getString(OpenCDINamedBeanDialog.BEAN_NAME);
            if (beanName == null) {
                return null;
            }
            String beanDeleted = mem.getString(OpenCDINamedBeanDialog.DELETED);
            if (beanDeleted != null && OpenCDINamedBeanDialog.YES.equals(beanDeleted)) {
                return null;
            }
            return new CDINamedBeanWrapper(beanName, projectName);
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            CDINamedBeanWrapper beanWrapper = (CDINamedBeanWrapper)item;
            XMLMemento mem = (XMLMemento)memento;
            mem.putString(OpenCDINamedBeanDialog.PROJECT_NAME, beanWrapper.getProjectName());
            mem.putString(OpenCDINamedBeanDialog.BEAN_NAME, beanWrapper.getBeanName());
        }

        public void save(IMemento memento) {
            super.save(memento);
            if (!(memento instanceof XMLMemento)) {
                return;
            }
            XMLMemento xmlMemento = (XMLMemento)memento;
            OpenCDINamedBeanDialog.saveMemento(xmlMemento);
        }
    }

    public class CDINamedBeanWrapper {
        private String beanName;
        private String projectName;
        private IBean bean;

        public CDINamedBeanWrapper(String beanName, String projectName) {
            this.beanName = beanName;
            this.projectName = projectName;
        }

        public CDINamedBeanWrapper(String beanName, String projectName, IBean bean) {
            this(beanName, projectName);
            this.bean = bean;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public IBean getBean() {
            if (this.bean == null) {
                Collection beans;
                ICDIProject cdiProject;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                if (project.isAccessible() && (cdiProject = CDICorePlugin.getCDIProject((IProject)project, (boolean)true)) != null && !(beans = cdiProject.getBeans(this.beanName, true)).isEmpty()) {
                    return (IBean)beans.iterator().next();
                }
                return null;
            }
            return this.bean;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CDINamedBeanWrapper)) {
                return false;
            }
            String s1 = new CDINamedBeanLabelProvider().getTextString(this);
            String s2 = new CDINamedBeanLabelProvider().getTextString(obj);
            return s1.equals(s2);
        }

        public int hashCode() {
            return new CDINamedBeanLabelProvider().getTextString(this).hashCode();
        }
    }
}

