/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.wizard.CheckBoxEditorWrapper;
import org.jboss.tools.cdi.ui.wizard.NewBeanWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewBeansXMLCreationWizard;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class BeansXMLAccess {
    String folderName;
    String entity;
    String attribute;
    protected NewTypeWizardPage page;
    protected CheckBoxEditorWrapper check = null;
    protected boolean isEnabled = true;

    public BeansXMLAccess(NewTypeWizardPage page, String folderName, String entity, String attribute) {
        this.page = page;
        this.folderName = folderName;
        this.entity = entity;
        this.attribute = attribute;
    }

    public void create(Composite composite) {
        this.create(composite, true);
    }

    public void create(Composite composite, boolean initValue) {
        String label = "Register in beans.xml";
        this.check = NewBeanWizardPage.createCheckBoxField(composite, "register", label, initValue);
    }

    public boolean isSelected() {
        if (this.check != null) {
            return this.check.composite.getValue() == Boolean.TRUE && this.check.checkBox.isEnabled();
        }
        return false;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
        this.validate();
    }

    public void validate() {
        if (this.check == null) {
            return;
        }
        IPackageFragmentRoot p = this.page.getPackageFragmentRoot();
        if (p != null && p.getResource().exists()) {
            String typeName = String.valueOf(this.page.getPackageText()) + "." + this.page.getTypeName();
            IProject project = p.getResource().getProject();
            boolean b = this.isRegisteredInBeansXML(project, typeName);
            this.check.composite.setEnabled(!b && this.isEnabled);
        } else {
            this.check.composite.setEnabled(this.isEnabled);
        }
    }

    public void registerInBeansXML() {
        IProject project = this.page.getCreatedType().getResource().getProject();
        IPath path = NewBeansXMLCreationWizard.getContainerForBeansXML(project);
        if (path != null) {
            XModelObject o;
            IFile beansxml = project.getFile(path = path.append("beans.xml").removeFirstSegments(1));
            if (!beansxml.exists()) {
                try {
                    BeansXMLAccess.createBeansXML(beansxml);
                }
                catch (CoreException e) {
                    CDIUIPlugin.getDefault().logError(e);
                }
            }
            if (beansxml.exists() && (o = EclipseResourceUtil.createObjectForResource((IResource)beansxml)) != null) {
                XModelObject as = o.getChildByPath(this.folderName);
                XModelObject c = as.getModel().createModelObject(this.entity, new Properties());
                c.setAttributeValue(this.attribute, this.page.getCreatedType().getFullyQualifiedName());
                if (as.getChildByPath(c.getPathPart()) == null) {
                    try {
                        DefaultCreateHandler.addCreatedObject((XModelObject)as, (XModelObject)c, (int)0);
                        XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)o, (Properties)new Properties());
                    }
                    catch (CoreException e) {
                        CDIUIPlugin.getDefault().logError(e);
                    }
                }
            }
        }
    }

    public boolean isRegisteredInBeansXML(IProject project, String typeName) {
        XModelObject o;
        IFile beansxml;
        IPath path = NewBeansXMLCreationWizard.getContainerForBeansXML(project);
        if (path != null && (beansxml = project.getFile(path = path.append("beans.xml").removeFirstSegments(1))).exists() && (o = EclipseResourceUtil.createObjectForResource((IResource)beansxml)) != null) {
            return o.getChildByPath(String.valueOf(this.folderName) + "/" + typeName) != null;
        }
        return false;
    }

    public static void createBeansXML(IFile f) throws CoreException {
        if (f.exists()) {
            return;
        }
        IFolder folder = (IFolder)f.getParent();
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        f.create(BeansXMLAccess.getBeansXMLInitialContents(), true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static InputStream getBeansXMLInitialContents() {
        FileAnyImpl file = (FileAnyImpl)XModelFactory.getDefaultInstance().createModelObject("FileCDIBeans", new Properties());
        return new ByteArrayInputStream(file.getAsText().getBytes());
    }
}

