/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.internal.core.refactoring.AddQualifiersToBeanProcessor;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.AddQualifiersToBeanWizard;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.TestableResolutionWithDialog;

public class MakeInjectedPointUnambiguousMarkerResolution
implements IQuickFix,
TestableResolutionWithDialog {
    private String label;
    private IInjectionPoint injectionPoint;
    private List<IBean> beans;
    private IBean selectedBean;

    public MakeInjectedPointUnambiguousMarkerResolution(IInjectionPoint injectionPoint, List<IBean> beans, int index) {
        this.injectionPoint = injectionPoint;
        this.beans = beans;
        this.selectedBean = beans.get(index);
        this.label = MessageFormat.format(CDIUIMessages.MAKE_INJECTED_POINT_UNAMBIGUOUS_TITLE, this.selectedBean.getElementName());
    }

    public String getLabel() {
        return this.label;
    }

    public void runForTest(IMarker marker) {
        this.internal_run(true);
    }

    public void run(IMarker marker) {
        this.internal_run(false);
    }

    private void internal_run(boolean test) {
        AddQualifiersToBeanProcessor processor = new AddQualifiersToBeanProcessor(this.label, this.injectionPoint, this.beans, this.selectedBean);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
        AddQualifiersToBeanWizard wizard = new AddQualifiersToBeanWizard(refactoring);
        wizard.showWizard();
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_EDIT);
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        this.internal_run(false);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.label;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

