/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class ChangeAnnotationMarkerResolution
extends BaseMarkerResolution {
    private IAnnotation annotation;
    protected String sourceString = "";
    protected String changeString = "@";
    private boolean useBraces = true;
    private String[] qualifiedNames = new String[0];

    public ChangeAnnotationMarkerResolution(IAnnotation annotation) {
        super(CDIMarkerResolutionUtils.getJavaMember((IJavaElement)annotation).getCompilationUnit());
        this.annotation = annotation;
        this.changeString = String.valueOf(this.changeString) + annotation.getElementName();
        try {
            this.sourceString = annotation.getSource();
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        this.label = NLS.bind((String)CDIUIMessages.CHANGE_ANNOTATION_MARKER_RESOLUTION_TITLE, (Object)this.sourceString, (Object)this.changeString);
        this.init();
    }

    public ChangeAnnotationMarkerResolution(IAnnotation annotation, String parameter) {
        this(annotation);
        this.qualifiedNames = new String[]{parameter};
        String shortName = CDIMarkerResolutionUtils.getShortName((String)parameter);
        this.changeString = String.valueOf(this.changeString) + "(" + shortName + ")";
        this.label = NLS.bind((String)CDIUIMessages.CHANGE_ANNOTATION_MARKER_RESOLUTION_TITLE, (Object)this.sourceString, (Object)this.changeString);
        this.init();
    }

    public ChangeAnnotationMarkerResolution(IAnnotation annotation, String[] typeNames) {
        this(annotation);
        this.qualifiedNames = typeNames;
        String[] shortNames = CDIMarkerResolutionUtils.getShortNames((String[])this.qualifiedNames);
        String totalList = CDIMarkerResolutionUtils.getTotalList((String[])shortNames);
        if (this.useBraces) {
            totalList = "{" + totalList + "}";
        }
        this.changeString = String.valueOf(this.changeString) + "(" + totalList + ")";
        this.label = NLS.bind((String)CDIUIMessages.CHANGE_ANNOTATION_MARKER_RESOLUTION_TITLE, (Object)this.sourceString, (Object)this.changeString);
        this.init();
    }

    public ChangeAnnotationMarkerResolution(IAnnotation annotation, String[] typeNames, boolean useBraces) {
        this(annotation, typeNames);
        this.useBraces = useBraces;
        this.label = NLS.bind((String)CDIUIMessages.CHANGE_ANNOTATION_MARKER_RESOLUTION_TITLE, (Object)this.sourceString, (Object)this.changeString);
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            String[] stringArray = this.qualifiedNames;
            int n = this.qualifiedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String qualifiedName = stringArray[n2];
                CDIMarkerResolutionUtils.addImport((String)qualifiedName, (ICompilationUnit)compilationUnit, (boolean)true, (MultiTextEdit)edit);
                ++n2;
            }
            IAnnotation workingCopyAnnotation = (IAnnotation)CDIMarkerResolutionUtils.findWorkingCopy((ICompilationUnit)compilationUnit, (IJavaElement)this.annotation);
            ReplaceEdit re = new ReplaceEdit(workingCopyAnnotation.getSourceRange().getOffset(), workingCopyAnnotation.getSourceRange().getLength(), this.changeString);
            edit.addChild((TextEdit)re);
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_CHANGE);
    }
}

