/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class AddTargetAnnotationMarkerResolution
extends BaseMarkerResolution {
    private IType type;
    private String[] qualifiedNames;
    private String[] shortNames;
    private String totalList;

    public AddTargetAnnotationMarkerResolution(IType type, String[] typeNames) {
        super(type.getCompilationUnit());
        this.qualifiedNames = typeNames;
        this.type = type;
        this.shortNames = CDIMarkerResolutionUtils.getShortNames((String[])this.qualifiedNames);
        this.totalList = "{" + CDIMarkerResolutionUtils.getTotalList((String[])this.shortNames) + "}";
        this.label = NLS.bind((String)CDIUIMessages.ADD_TARGET_MARKER_RESOLUTION_TITLE, (Object)this.totalList, (Object)type.getElementName());
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            String[] stringArray = this.qualifiedNames;
            int n = this.qualifiedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String qualifiedName = stringArray[n2];
                CDIMarkerResolutionUtils.addImport((String)qualifiedName, (ICompilationUnit)compilationUnit, (boolean)true, (MultiTextEdit)edit);
                ++n2;
            }
            CDIMarkerResolutionUtils.addAnnotation((String)"java.lang.annotation.Target", (ICompilationUnit)compilationUnit, (IJavaElement)this.type, (String)("(" + this.totalList + ")"), (MultiTextEdit)edit);
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_ADD);
    }
}

