/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;

public class AddLocalBeanMarkerResolution
extends BaseMarkerResolution {
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String PROTECTED = "protected";
    private static final String SPACE = " ";
    private IMethod method;

    public AddLocalBeanMarkerResolution(IMethod method) {
        super(CDIMarkerResolutionUtils.getJavaMember((IJavaElement)method).getCompilationUnit());
        this.label = MessageFormat.format(CDIUIMessages.ADD_LOCAL_BEAN_MARKER_RESOLUTION_TITLE, method.getDeclaringType().getElementName());
        this.method = method;
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            IBuffer buffer = compilationUnit.getBuffer();
            int flag = this.method.getFlags();
            String text = buffer.getText(this.method.getSourceRange().getOffset(), this.method.getSourceRange().getLength());
            int position = this.method.getSourceRange().getOffset();
            if (!Flags.isPublic((int)flag)) {
                if (Flags.isPrivate((int)flag)) {
                    edit.addChild((TextEdit)new ReplaceEdit(position += text.indexOf(PRIVATE), PRIVATE.length(), PUBLIC));
                } else if (Flags.isProtected((int)flag)) {
                    edit.addChild((TextEdit)new ReplaceEdit(position += text.indexOf(PROTECTED), PROTECTED.length(), PUBLIC));
                } else {
                    String type = Signature.getSignatureSimpleName((String)this.method.getReturnType());
                    edit.addChild((TextEdit)new InsertEdit(position += text.indexOf(type), "public "));
                }
            }
            MarkerResolutionUtils.addAnnotation((String)"javax.ejb.LocalBean", (ICompilationUnit)compilationUnit, (IJavaElement)this.method.getDeclaringType(), (String)"", (MultiTextEdit)edit);
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_ADD);
    }
}

